/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.aaar;

import de.learnlib.algorithm.aaar.abstraction.AbstractAbstractionTree;
import java.util.Collection;
import java.util.function.Function;
import net.automatalib.automaton.transducer.MooreMachine;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TranslatingMooreMachine<S, AI, CI, T, O>
implements MooreMachine<S, CI, T, O> {
    private final MooreMachine<S, CI, T, O> delegate;
    private final Function<CI, ? extends AbstractAbstractionTree<AI, CI, ?>> treeFetcher;

    public TranslatingMooreMachine(MooreMachine<S, CI, T, O> delegate, Function<CI, ? extends AbstractAbstractionTree<AI, CI, ?>> treeFetcher) {
        this.delegate = delegate;
        this.treeFetcher = treeFetcher;
    }

    @Override
    public Collection<S> getStates() {
        return this.delegate.getStates();
    }

    @Override
    public O getStateOutput(S s2) {
        return this.delegate.getStateOutput(s2);
    }

    @Override
    public @Nullable T getTransition(S s2, CI i) {
        AbstractAbstractionTree<AI, CI, ?> tree = this.treeFetcher.apply(i);
        AI ai = tree.getAbstractSymbol(i);
        CI ci = tree.getRepresentative(ai);
        return this.delegate.getTransition(s2, ci);
    }

    @Override
    public S getSuccessor(T t) {
        return this.delegate.getSuccessor(t);
    }

    @Override
    public @Nullable S getInitialState() {
        return this.delegate.getInitialState();
    }
}

