/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.adt.config.model.replacer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.learnlib.algorithm.adt.adt.ADT;
import de.learnlib.algorithm.adt.adt.ADTNode;
import de.learnlib.algorithm.adt.api.SubtreeReplacer;
import de.learnlib.algorithm.adt.config.model.ADSCalculator;
import de.learnlib.algorithm.adt.model.ReplacementResult;
import de.learnlib.algorithm.adt.util.ADTUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.smartcollection.ReflexiveMapView;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SingleReplacer
implements SubtreeReplacer {
    private final ADSCalculator adsCalculator;

    public SingleReplacer(ADSCalculator adsProvider) {
        this.adsCalculator = adsProvider;
    }

    @Override
    public <S, I, O> Set<ReplacementResult<S, I, O>> computeReplacements(MealyMachine<S, I, ?, O> hypothesis, Alphabet<I> inputs, ADT<S, I, O> adt) {
        Set<ADTNode<S, I, O>> candidates = ADTUtil.collectADSNodes(adt.getRoot());
        candidates.remove(adt.getRoot());
        ImmutableMap candidatesScore = Maps.toMap(candidates, node -> {
            int resets = 1 + ADTUtil.collectResetNodes(node).size();
            int finals = ADTUtil.collectLeaves(node).size();
            return (double)resets / (double)finals;
        });
        ArrayList<ADTNode<S, I, O>> sortedCandidates = new ArrayList<ADTNode<S, I, O>>(candidates);
        sortedCandidates.sort(Comparator.comparingDouble(candidatesScore::get));
        for (ADTNode aDTNode : sortedCandidates) {
            Optional<ADTNode<S, I, O>> potentialADS;
            Set targetStates;
            ReplacementResult<S, I, O> replacementResult = SingleReplacer.computeParentExtension(hypothesis, inputs, aDTNode, targetStates = ADTUtil.collectHypothesisStates(aDTNode), this.adsCalculator);
            if (replacementResult != null) {
                return Collections.singleton(replacementResult);
            }
            if (ADTUtil.collectResetNodes(aDTNode).isEmpty() || !(potentialADS = this.adsCalculator.compute(hypothesis, inputs, targetStates)).isPresent()) continue;
            return Collections.singleton(new ReplacementResult<S, I, O>(aDTNode, potentialADS.get()));
        }
        return Collections.emptySet();
    }

    static <S, I, O> @Nullable ReplacementResult<S, I, O> computeParentExtension(MealyMachine<S, I, ?, O> hypothesis, Alphabet<I> inputs, ADTNode<S, I, O> node, Set<S> targetStates, ADSCalculator adsCalculator) {
        ADTNode parentReset = (ADTNode)node.getParent();
        assert (ADTUtil.isResetNode(parentReset)) : "should not happen";
        Word incomingTraceInput = ADTUtil.buildTraceForNode(parentReset).getFirst();
        AbstractMap currentToInitialMapping = new ReflexiveMapView<S>(targetStates);
        for (Object i : incomingTraceInput) {
            HashMap nextMapping = new HashMap();
            for (Map.Entry entry : currentToInitialMapping.entrySet()) {
                Object successor = hypothesis.getSuccessor(entry.getKey(), i);
                if (nextMapping.containsKey(successor)) {
                    return null;
                }
                nextMapping.put(successor, entry.getValue());
            }
            currentToInitialMapping = nextMapping;
        }
        Optional potentialExtension = adsCalculator.compute(hypothesis, inputs, currentToInitialMapping.keySet());
        if (potentialExtension.isPresent()) {
            ADTNode extension = potentialExtension.get();
            for (ADTNode aDTNode : ADTUtil.collectLeaves(extension)) {
                aDTNode.setHypothesisState(currentToInitialMapping.get(aDTNode.getHypothesisState()));
            }
            return new ReplacementResult(parentReset, potentialExtension.get());
        }
        return null;
    }
}

