/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.adt.util;

import de.learnlib.algorithm.adt.adt.ADTLeafNode;
import de.learnlib.algorithm.adt.adt.ADTNode;
import de.learnlib.algorithm.adt.adt.ADTSymbolNode;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.util.Pair;
import net.automatalib.graph.ads.ADSNode;
import net.automatalib.graph.ads.RecursiveADSNode;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

public final class ADTUtil {
    private ADTUtil() {
    }

    public static <S, I, O> boolean isSymbolNode(ADTNode<S, I, O> node) {
        return ADTUtil.checkNodeType(node, ADTNode.NodeType.SYMBOL_NODE);
    }

    private static <S, I, O> boolean checkNodeType(ADTNode<S, I, O> node, ADTNode.NodeType type) {
        return node != null && node.getNodeType() == type;
    }

    public static <S, I, O> ADTNode<S, I, O> getStartOfADS(ADTNode<S, I, O> node) {
        ADTNode iter = node;
        while (iter.getParent() != null && !ADTUtil.isResetNode((ADTNode)iter.getParent())) {
            iter = (ADTNode)iter.getParent();
        }
        return iter;
    }

    public static <S, I, O> boolean isResetNode(ADTNode<S, I, O> node) {
        return ADTUtil.checkNodeType(node, ADTNode.NodeType.RESET_NODE);
    }

    public static <S, I, O> Set<S> collectHypothesisStates(ADTNode<S, I, O> root) {
        LinkedHashSet result = new LinkedHashSet();
        ADTUtil.collectTransformedLeavesRecursively(result, root, RecursiveADSNode::getHypothesisState);
        return result;
    }

    public static <S, I, O> Set<ADTNode<S, I, O>> collectLeaves(ADTNode<S, I, O> root) {
        LinkedHashSet<ADTNode<S, I, O>> result = new LinkedHashSet<ADTNode<S, I, O>>();
        ADTUtil.collectTransformedLeavesRecursively(result, root, Function.identity());
        return result;
    }

    private static <S, I, O, T> void collectTransformedLeavesRecursively(Set<T> nodes, ADTNode<S, I, O> current, Function<ADTNode<S, I, O>, T> transformer) {
        if (ADTUtil.isLeafNode(current)) {
            nodes.add(transformer.apply(current));
        } else {
            for (ADTNode n : current.getChildren().values()) {
                ADTUtil.collectTransformedLeavesRecursively(nodes, n, transformer);
            }
        }
    }

    public static <S, I, O> Set<ADTNode<S, I, O>> collectADSNodes(ADTNode<S, I, O> root) {
        LinkedHashSet<ADTNode<S, I, O>> result = new LinkedHashSet<ADTNode<S, I, O>>();
        result.add(root);
        ADTUtil.collectADSNodesRecursively(result, root);
        return result;
    }

    private static <S, I, O> void collectADSNodesRecursively(Set<ADTNode<S, I, O>> nodes, ADTNode<S, I, O> current) {
        if (ADTUtil.isResetNode(current)) {
            nodes.addAll(current.getChildren().values());
        }
        for (ADTNode n : current.getChildren().values()) {
            ADTUtil.collectADSNodesRecursively(nodes, n);
        }
    }

    public static <S, I, O> Set<ADTNode<S, I, O>> collectResetNodes(ADTNode<S, I, O> root) {
        LinkedHashSet<ADTNode<S, I, O>> result = new LinkedHashSet<ADTNode<S, I, O>>();
        ADTUtil.collectResetNodesRecursively(result, root);
        return result;
    }

    private static <S, I, O> void collectResetNodesRecursively(Set<ADTNode<S, I, O>> nodes, ADTNode<S, I, O> current) {
        if (ADTUtil.isResetNode(current)) {
            nodes.add(current);
        }
        for (ADTNode n : current.getChildren().values()) {
            ADTUtil.collectResetNodesRecursively(nodes, n);
        }
    }

    public static <S, I, O> Set<ADTNode<S, I, O>> collectDirectSubADSs(ADTNode<S, I, O> node) {
        LinkedHashSet<ADTNode<S, I, O>> result = new LinkedHashSet<ADTNode<S, I, O>>();
        ADTUtil.collectDirectSubTreesRecursively(result, node);
        return result;
    }

    private static <S, I, O> void collectDirectSubTreesRecursively(Set<ADTNode<S, I, O>> nodes, ADTNode<S, I, O> current) {
        if (ADTUtil.isResetNode(current)) {
            nodes.addAll(current.getChildren().values());
        } else {
            for (ADTNode n : current.getChildren().values()) {
                ADTUtil.collectDirectSubTreesRecursively(nodes, n);
            }
        }
    }

    public static <S, I, O> Pair<Word<I>, Word<O>> buildTraceForNode(ADTNode<S, I, O> node) {
        ADTNode nodeIter = node;
        WordBuilder inputBuilder = new WordBuilder();
        WordBuilder<O> outputBuilder = new WordBuilder<O>();
        for (ADTNode parentIter = (ADTNode)node.getParent(); parentIter != null && !ADTUtil.isResetNode(parentIter); parentIter = (ADTNode)parentIter.getParent()) {
            inputBuilder.append(parentIter.getSymbol());
            outputBuilder.append(ADTUtil.getOutputForSuccessor(parentIter, nodeIter));
            nodeIter = parentIter;
        }
        return Pair.of(inputBuilder.reverse().toWord(), outputBuilder.reverse().toWord());
    }

    public static <S, I, O> O getOutputForSuccessor(ADTNode<S, I, O> node, ADTNode<S, I, O> successor) {
        if (!node.equals(successor.getParent())) {
            throw new IllegalArgumentException("No parent relationship");
        }
        for (Map.Entry entry : node.getChildren().entrySet()) {
            if (!((ADTNode)entry.getValue()).equals(successor)) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("No child relationship");
    }

    public static <S, I, O> ADTNode<S, I, O> buildFromADS(ADSNode<S, I, O> node) {
        if (node.isLeaf()) {
            return new ADTLeafNode(null, node.getHypothesisState());
        }
        ADTSymbolNode result = new ADTSymbolNode(null, node.getSymbol());
        for (Map.Entry entry : node.getChildren().entrySet()) {
            Object adsOutput = entry.getKey();
            ADSNode adsNode = (ADSNode)entry.getValue();
            ADTNode<S, I, O> newChild = ADTUtil.buildFromADS(adsNode);
            newChild.setParent(result);
            result.getChildren().put(adsOutput, newChild);
        }
        return result;
    }

    public static <S, I, O> int computeEffectiveResets(ADTNode<S, I, O> adt) {
        return ADTUtil.computeEffectiveResetsInternal(adt, 0);
    }

    private static <S, I, O> int computeEffectiveResetsInternal(ADTNode<S, I, O> ads, int accumulatedResets) {
        if (ADTUtil.isLeafNode(ads)) {
            return accumulatedResets;
        }
        int nextCosts = ADTUtil.isResetNode(ads) ? accumulatedResets + 1 : accumulatedResets;
        return ads.getChildren().values().stream().mapToInt(x -> ADTUtil.computeEffectiveResetsInternal(x, nextCosts)).sum();
    }

    public static <S, I, O> Pair<ADTNode<S, I, O>, ADTNode<S, I, O>> buildADSFromTrace(MealyMachine<S, I, ?, O> automaton, Word<I> trace, S state) {
        ADTSymbolNode head;
        Iterator<I> sequenceIter = trace.iterator();
        I input = sequenceIter.next();
        ADTSymbolNode tempADS = head = new ADTSymbolNode(null, input);
        I tempInput = input;
        S tempState = state;
        while (sequenceIter.hasNext()) {
            I nextInput = sequenceIter.next();
            ADTSymbolNode nextNode = new ADTSymbolNode(tempADS, nextInput);
            Object oldOutput = automaton.getOutput(tempState, tempInput);
            tempADS.getChildren().put(oldOutput, nextNode);
            tempADS = nextNode;
            tempState = automaton.getSuccessor(tempState, tempInput);
            tempInput = nextInput;
        }
        return Pair.of(head, tempADS);
    }

    public static <S, I, O> ADTNode<S, I, O> buildADSFromObservation(Word<I> input, Word<O> output, S finalState) {
        ADTSymbolNode result;
        if (input.size() != output.size()) {
            throw new IllegalArgumentException("Arguments differ in length");
        }
        Iterator<I> inputIterator = input.iterator();
        Iterator<O> outputIterator = output.iterator();
        ADTSymbolNode nodeIter = result = new ADTSymbolNode(null, inputIterator.next());
        while (inputIterator.hasNext()) {
            ADTSymbolNode nextNode = new ADTSymbolNode(nodeIter, inputIterator.next());
            nodeIter.getChildren().put(outputIterator.next(), nextNode);
            nodeIter = nextNode;
        }
        ADTLeafNode finalNode = new ADTLeafNode(nodeIter, finalState);
        nodeIter.getChildren().put(outputIterator.next(), finalNode);
        return result;
    }

    public static <S, I, O> boolean mergeADS(ADTNode<S, I, O> parent, ADTNode<S, I, O> child) {
        ADTNode parentIter = parent;
        ADTNode childIter = child;
        while (!(ADTUtil.isLeafNode(parentIter) || ADTUtil.isResetNode(parentIter) || ADTUtil.isLeafNode(childIter))) {
            if (!Objects.equals(parentIter.getSymbol(), childIter.getSymbol())) {
                return false;
            }
            Map childSuccessors = childIter.getChildren();
            if (childSuccessors.size() != 1) {
                throw new IllegalArgumentException("No single trace child");
            }
            Map parentSuccessors = parentIter.getChildren();
            Map.Entry childSuccessor = childSuccessors.entrySet().iterator().next();
            Object childOutput = childSuccessor.getKey();
            ADTNode childADS = (ADTNode)childSuccessor.getValue();
            if (!parentSuccessors.containsKey(childOutput)) {
                parentSuccessors.put(childOutput, childADS);
                childADS.setParent(parentIter);
                return true;
            }
            parentIter = (ADTNode)parentSuccessors.get(childOutput);
            childIter = childADS;
        }
        return false;
    }

    public static <S, I, O> boolean isLeafNode(ADTNode<S, I, O> node) {
        return ADTUtil.checkNodeType(node, ADTNode.NodeType.LEAF_NODE);
    }
}

