/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.lstar.mealy;

import java.util.ArrayList;
import java.util.List;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.word.Word;

public final class LStarMealyUtil {
    private LStarMealyUtil() {
    }

    public static <I> List<Word<I>> ensureSuffixCompliancy(List<Word<I>> suffixes, Alphabet<I> alphabet, boolean needsConsistencyCheck) {
        ArrayList<Word<I>> compSuffixes = new ArrayList<Word<I>>();
        if (needsConsistencyCheck) {
            for (int i = 0; i < alphabet.size(); ++i) {
                compSuffixes.add(Word.fromLetter(alphabet.getSymbol(i)));
            }
        }
        for (Word<I> w : suffixes) {
            if (w.isEmpty() || needsConsistencyCheck && w.length() == 1) continue;
            compSuffixes.add(w);
        }
        return compSuffixes;
    }
}

