/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.oml.lstar;

import de.learnlib.Resumable;
import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.oml.lstar.Hypothesis;
import de.learnlib.algorithm.oml.lstar.OptimalLStarState;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.concept.InputAlphabetHolder;
import net.automatalib.word.Word;

abstract class AbstractOptimalLStar<M, I, D>
implements LearningAlgorithm<M, I, D>,
Hypothesis<I, D>,
InputAlphabetHolder<I>,
Resumable<OptimalLStarState<I, D>> {
    private final Alphabet<I> alphabet;
    final MembershipOracle<I, D> mqs;
    final MembershipOracle<I, D> ceqs;
    private final Set<Word<I>> shortPrefixes;
    private final Map<Word<I>, List<D>> rows;
    private final List<Word<I>> suffixes;

    AbstractOptimalLStar(Alphabet<I> alphabet, MembershipOracle<I, D> mqs, MembershipOracle<I, D> ceqs, List<Word<I>> initialSuffixes) {
        this.alphabet = alphabet;
        this.mqs = mqs;
        this.ceqs = ceqs;
        this.suffixes = new ArrayList<Word<I>>(initialSuffixes);
        this.shortPrefixes = new HashSet<Word<I>>();
        this.rows = new HashMap<Word<I>, List<D>>();
    }

    abstract int maxSearchIndex(int var1);

    abstract void automatonFromTable();

    abstract D suffix(D var1, int var2);

    abstract boolean symbolInconsistency(Word<I> var1, Word<I> var2, I var3);

    @Override
    public void startLearning() {
        this.initTable();
        this.learnLoop();
    }

    @Override
    public boolean refineHypothesis(DefaultQuery<I, D> counterexample) {
        LinkedHashSet<DefaultQuery<I, D>> witnesses = new LinkedHashSet<DefaultQuery<I, D>>();
        witnesses.add(counterexample);
        boolean refined = this.refineWithWitness(counterexample, witnesses);
        if (!refined) {
            return false;
        }
        do {
            DefaultQuery w;
            Iterator iterator = witnesses.iterator();
            while (iterator.hasNext() && !(refined = this.refineWithWitness(w = (DefaultQuery)iterator.next(), witnesses))) {
            }
        } while (refined);
        assert (this.size() == this.shortPrefixes.size());
        return true;
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    private boolean refineWithWitness(DefaultQuery<I, D> counterexample, Set<DefaultQuery<I, D>> witnesses) {
        boolean valid = false;
        while (this.counterExampleValid(counterexample)) {
            valid = true;
            this.analyzeCounterexample(counterexample, witnesses);
            this.learnLoop();
        }
        return valid;
    }

    private void initTable() {
        Word epsilon = Word.epsilon();
        List<D> rowData = this.initRow(epsilon);
        this.rows.put(epsilon, rowData);
        this.addShortPrefix(epsilon);
    }

    private void analyzeCounterexample(DefaultQuery<I, D> counterexample, Set<DefaultQuery<I, D>> witnesses) {
        int mid;
        Word ceInput = counterexample.getInput();
        Word ua = null;
        int upper = this.maxSearchIndex(ceInput.length());
        int lower = 0;
        Object hypOut = this.getOutput(ceInput, ceInput.length());
        while (upper - lower > 1) {
            mid = (upper + lower) / 2;
            Word prefix = ceInput.prefix(mid);
            Word suffix = ceInput.suffix(ceInput.length() - mid);
            List rowData = this.rowForState(prefix);
            boolean stillCe = false;
            for (Word u : this.getShortPrefixes(rowData)) {
                D sysOut = this.suffix(this.ceqs.answerQuery(u, suffix), suffix.length());
                if (Objects.equals(sysOut, this.suffix(hypOut, suffix.size()))) continue;
                ua = u.append(suffix.firstSymbol());
                lower = mid;
                stillCe = true;
                break;
            }
            if (stillCe) continue;
            upper = mid;
        }
        if (ua == null) {
            assert (upper == 1);
            ua = ceInput.prefix(1);
        }
        mid = (upper + lower) / 2;
        Word sprime = ceInput.suffix(ceInput.length() - (mid + 1));
        List<D> rnext = this.getRow(ua);
        for (Word<I> uprime : this.getShortPrefixes(rnext)) {
            witnesses.add(new DefaultQuery<I, D>(uprime, sprime, this.ceqs.answerQuery(uprime, sprime)));
        }
        witnesses.add(new DefaultQuery(ua, sprime, this.ceqs.answerQuery(ua, sprime)));
        this.addShortPrefix(ua);
    }

    private boolean counterExampleValid(DefaultQuery<I, D> counterexample) {
        assert (!counterexample.getSuffix().isEmpty());
        Object hypOut = this.getOutput(counterexample.getInput(), counterexample.getSuffix().length());
        return !Objects.equals(hypOut, counterexample.getOutput());
    }

    private void learnLoop() {
        while (this.findInconsistency() || this.findUnclosedness()) {
            this.completeObservations();
        }
        this.automatonFromTable();
    }

    private boolean findInconsistency() {
        ArrayList<Word<I>> shortAsList = new ArrayList<Word<I>>(this.shortPrefixes);
        for (int left = 0; left < shortAsList.size() - 1; ++left) {
            for (int right = left + 1; right < shortAsList.size(); ++right) {
                if (!this.findInconsistency((Word)shortAsList.get(left), (Word)shortAsList.get(right))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean findInconsistency(Word<I> u1, Word<I> u2) {
        List<D> rowData2;
        List<D> rowData1 = this.rows.get(u1);
        if (!Objects.equals(rowData1, rowData2 = this.rows.get(u2))) {
            return false;
        }
        for (Object a : this.alphabet) {
            rowData1 = this.rows.get(u1.append(a));
            rowData2 = this.rows.get(u2.append(a));
            assert (rowData1 != null && rowData2 != null);
            if (!rowData1.equals(rowData2)) {
                for (int i = 0; i < rowData1.size(); ++i) {
                    if (Objects.equals(rowData1.get(i), rowData2.get(i))) continue;
                    Word<I> newSuffx = this.suffixes.get(i).prepend(a);
                    this.suffixes.add(newSuffx);
                    return true;
                }
            }
            if (!this.symbolInconsistency(u1, u2, a)) continue;
            return true;
        }
        return false;
    }

    private List<Word<I>> getShortPrefixes(Word<I> prefix) {
        List<D> rowData = this.rows.get(prefix);
        assert (rowData != null);
        return this.getShortPrefixes(rowData);
    }

    List<Word<I>> getShortPrefixes(List<D> rowData) {
        ArrayList<Word<I>> shortReps = new ArrayList<Word<I>>();
        for (Map.Entry<Word<I>, List<D>> e : this.rows.entrySet()) {
            if (!this.shortPrefixes.contains(e.getKey()) || !rowData.equals(e.getValue())) continue;
            shortReps.add(e.getKey());
        }
        return shortReps;
    }

    Collection<Word<I>> getShortPrefixes() {
        return this.shortPrefixes;
    }

    List<D> getRow(Word<I> key) {
        List<D> row = this.rows.get(key);
        assert (row != null);
        return row;
    }

    void addSuffix(Word<I> suffix) {
        this.suffixes.add(suffix);
    }

    private boolean findUnclosedness() {
        for (Word<I> prefix : this.rows.keySet()) {
            List<Word<I>> shortReps = this.getShortPrefixes(prefix);
            if (!shortReps.isEmpty()) continue;
            this.addShortPrefix(prefix);
            return true;
        }
        return false;
    }

    private void completeObservations() {
        for (Map.Entry<Word<I>, List<D>> e : this.rows.entrySet()) {
            List<D> rowData = this.completeRow(e.getKey(), e.getValue());
            e.setValue(rowData);
        }
    }

    private List<D> initRow(Word<I> prefix) {
        ArrayList<D> rowData = new ArrayList<D>(this.suffixes.size());
        for (Word<I> suffix : this.suffixes) {
            rowData.add(this.suffix(this.mqs.answerQuery(prefix, suffix), suffix.size()));
        }
        return rowData;
    }

    private List<D> completeRow(Word<I> prefix, List<D> oldData) {
        if (this.suffixes.size() == oldData.size()) {
            return oldData;
        }
        ArrayList<D> rowData = new ArrayList<D>(this.suffixes.size());
        rowData.addAll(oldData);
        for (int i = oldData.size(); i < this.suffixes.size(); ++i) {
            rowData.add(this.suffix(this.mqs.answerQuery(prefix, this.suffixes.get(i)), this.suffixes.get(i).size()));
        }
        return rowData;
    }

    private void addShortPrefix(Word<I> shortPrefix) {
        assert (!this.shortPrefixes.contains(shortPrefix) && this.rows.containsKey(shortPrefix));
        this.shortPrefixes.add(shortPrefix);
        for (Object a : this.alphabet) {
            Word<I> newPrefix = shortPrefix.append(a);
            List<D> rowData = this.initRow(newPrefix);
            this.rows.put(newPrefix, rowData);
        }
    }

    @Override
    public OptimalLStarState<I, D> suspend() {
        return new OptimalLStarState<I, D>(this.shortPrefixes, this.rows, this.suffixes);
    }

    @Override
    public void resume(OptimalLStarState<I, D> state) {
        this.shortPrefixes.clear();
        this.rows.clear();
        this.suffixes.clear();
        this.shortPrefixes.addAll(state.getShortPrefixes());
        this.rows.putAll(state.getRows());
        this.suffixes.addAll(state.getSuffixes());
        this.automatonFromTable();
    }
}

