/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.oml.ttt.dfa;

import de.learnlib.algorithm.oml.ttt.dfa.DecisionTreeDFA;
import de.learnlib.algorithm.oml.ttt.dt.DTLeaf;
import de.learnlib.algorithm.oml.ttt.pt.PTNode;
import de.learnlib.algorithm.oml.ttt.pt.PrefixTree;
import java.util.Collection;
import net.automatalib.automaton.fsa.DFA;

class HypothesisDFA<I>
implements DFA<DTLeaf<I, Boolean>, I> {
    private final PrefixTree<I, Boolean> ptree;
    private final DecisionTreeDFA<I> dtree;

    HypothesisDFA(PrefixTree<I, Boolean> ptree, DecisionTreeDFA<I> dtree) {
        this.ptree = ptree;
        this.dtree = dtree;
    }

    @Override
    public DTLeaf<I, Boolean> getTransition(DTLeaf<I, Boolean> s2, I a) {
        PTNode<I, Boolean> u = s2.getShortPrefixes().get(0);
        assert (u != null);
        PTNode<I, Boolean> ua = u.succ(a);
        assert (ua != null);
        DTLeaf<I, Boolean> dst = ua.state();
        assert (dst != null);
        return dst;
    }

    @Override
    public boolean isAccepting(DTLeaf<I, Boolean> s2) {
        assert (s2 != null);
        return this.dtree.isAccepting(s2);
    }

    @Override
    public DTLeaf<I, Boolean> getInitialState() {
        return this.ptree.root().state();
    }

    @Override
    public Collection<DTLeaf<I, Boolean>> getStates() {
        return this.dtree.leaves();
    }
}

