/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.oml.ttt.dfa;

import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.oml.ttt.AbstractOptimalTTT;
import de.learnlib.algorithm.oml.ttt.dfa.ChildrenDFA;
import de.learnlib.algorithm.oml.ttt.dfa.DecisionTreeDFA;
import de.learnlib.algorithm.oml.ttt.dfa.HypothesisDFA;
import de.learnlib.algorithm.oml.ttt.dt.AbstractDecisionTree;
import de.learnlib.algorithm.oml.ttt.dt.DTInnerNode;
import de.learnlib.algorithm.oml.ttt.dt.DTLeaf;
import de.learnlib.oracle.MembershipOracle;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.word.Word;

public class OptimalTTTDFA<I>
extends AbstractOptimalTTT<DFA<?, I>, I, Boolean>
implements LearningAlgorithm.DFALearner<I> {
    private final HypothesisDFA<I> hypothesis;
    private final DecisionTreeDFA<I> dtree;

    public OptimalTTTDFA(Alphabet<I> alphabet, MembershipOracle<I, Boolean> mqo) {
        this(alphabet, mqo, mqo);
    }

    public OptimalTTTDFA(Alphabet<I> alphabet, MembershipOracle<I, Boolean> mqs, MembershipOracle<I, Boolean> ceqs) {
        super(alphabet, ceqs);
        this.dtree = new DecisionTreeDFA<I>(mqs, alphabet, this.strie.root());
        DTInnerNode dtRoot = new DTInnerNode(null, this.dtree, new ChildrenDFA(), this.strie.root());
        this.dtree.setRoot(dtRoot);
        this.hypothesis = new HypothesisDFA<I>(this.ptree, this.dtree);
    }

    @Override
    protected int maxSearchIndex(int ceLength) {
        return ceLength;
    }

    @Override
    protected DTLeaf<I, Boolean> getState(Word<I> prefix) {
        return (DTLeaf)this.hypothesis.getState(prefix);
    }

    @Override
    public DFA<?, I> getHypothesisModel() {
        return this.hypothesis;
    }

    @Override
    protected AbstractDecisionTree<I, Boolean> dtree() {
        return this.dtree;
    }

    @Override
    protected Boolean suffix(Boolean output, int length) {
        return output;
    }

    @Override
    protected boolean isCanonical() {
        return this.hypothesis.getStates().stream().noneMatch(it -> it.getShortPrefixes().size() > 1);
    }

    @Override
    protected Boolean hypOutput(Word<I> word, int length) {
        return this.hypOutput(word);
    }

    protected Boolean hypOutput(Word<I> word) {
        DTLeaf<I, Boolean> s2 = this.getState(word);
        return this.dtree.isAccepting(s2);
    }
}

