/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.oml.ttt.dt;

import de.learnlib.algorithm.oml.ttt.dt.AbstractDTNode;
import de.learnlib.algorithm.oml.ttt.dt.AbstractDecisionTree;
import de.learnlib.algorithm.oml.ttt.dt.Children;
import de.learnlib.algorithm.oml.ttt.dt.DTLeaf;
import de.learnlib.algorithm.oml.ttt.pt.PTNode;
import de.learnlib.algorithm.oml.ttt.st.STNode;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DTInnerNode<I, D>
extends AbstractDTNode<I, D> {
    private final STNode<I> suffix;
    private final Children<I, D> children;

    public DTInnerNode(@Nullable DTInnerNode<I, D> parent, AbstractDecisionTree<I, D> tree, Children<I, D> children, STNode<I> suffix) {
        super(parent, tree);
        this.children = children;
        this.suffix = suffix;
    }

    public Children<I, D> getChildren() {
        return this.children;
    }

    @Override
    void sift(PTNode<I, D> prefix) {
        D out = this.tree.query(prefix, this.suffix);
        AbstractDTNode<I, D> succ = this.children.child(out);
        if (succ != null) {
            succ.sift(prefix);
        } else {
            DTLeaf<I, D> newLeaf = new DTLeaf<I, D>(this, this.tree, prefix);
            this.children.addChild(out, newLeaf);
            prefix.setState(newLeaf);
            for (Object a : this.tree.getAlphabet()) {
                PTNode<I, D> ua = prefix.append(a);
                this.tree.root().sift(ua);
            }
        }
    }

    @Override
    void leaves(List<DTLeaf<I, D>> list) {
        for (AbstractDTNode<I, D> n : this.children.all()) {
            n.leaves(list);
        }
    }

    void replace(DTLeaf<I, D> oldNode, DTInnerNode<I, D> newNode) {
        this.children.replace(oldNode, newNode);
    }

    STNode<I> suffix() {
        return this.suffix;
    }
}

