/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.procedural.adapter.mealy;

import de.learnlib.AccessSequenceTransformer;
import de.learnlib.algorithm.lstar.ce.ObservationTableCEXHandlers;
import de.learnlib.algorithm.lstar.closing.ClosingStrategies;
import de.learnlib.algorithm.lstar.mealy.ExtensibleLStarMealy;
import de.learnlib.datastructure.observationtable.ObservationTable;
import de.learnlib.oracle.MembershipOracle;
import java.util.Collections;
import java.util.Objects;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.word.Word;

public class LStarBaseAdapterMealy<I, O>
extends ExtensibleLStarMealy<I, O>
implements AccessSequenceTransformer<I> {
    public LStarBaseAdapterMealy(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle) {
        super(alphabet, oracle, Collections.singletonList(Word.epsilon()), ObservationTableCEXHandlers.CLASSIC_LSTAR, ClosingStrategies.CLOSE_FIRST);
    }

    @Override
    public Word<I> transformAccessSequence(Word<I> word) {
        Object hypothesis = super.getHypothesisModel();
        ObservationTable observationTable = super.getObservationTable();
        Object reachedState = hypothesis.getState(word);
        for (Word shortPrefix : observationTable.getShortPrefixes()) {
            Object reachedSPState = hypothesis.getState(shortPrefix);
            if (!Objects.equals(reachedState, reachedSPState)) continue;
            return shortPrefix;
        }
        throw new IllegalStateException("This should not have happened");
    }
}

