/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.procedural.sba;

import com.google.common.collect.Maps;
import de.learnlib.algorithm.procedural.SymbolWrapper;
import java.util.Collection;
import java.util.Map;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.procedural.SBA;
import org.checkerframework.checker.nullness.qual.Nullable;

class MappingSBA<S, I>
implements SBA<S, I> {
    private final ProceduralInputAlphabet<I> alphabet;
    private final Map<I, SymbolWrapper<I>> mapping;
    private final SBA<S, SymbolWrapper<I>> delegate;
    private final Map<I, DFA<?, I>> procedures;

    MappingSBA(ProceduralInputAlphabet<I> alphabet, Map<I, SymbolWrapper<I>> mapping, SBA<S, SymbolWrapper<I>> delegate) {
        this.alphabet = alphabet;
        this.mapping = mapping;
        this.delegate = delegate;
        Map p = delegate.getProcedures();
        this.procedures = Maps.newHashMapWithExpectedSize(p.size());
        for (Map.Entry e : p.entrySet()) {
            this.procedures.put(((SymbolWrapper)e.getKey()).getDelegate(), new DFAView((DFA)e.getValue()));
        }
    }

    @Override
    public @Nullable S getTransition(S state, I i) {
        SymbolWrapper<I> w = this.mapping.get(i);
        return w == null ? null : (S)this.delegate.getTransition(state, w);
    }

    @Override
    public boolean isAccepting(S state) {
        return this.delegate.isAccepting(state);
    }

    @Override
    public S getInitialState() {
        return this.delegate.getInitialState();
    }

    @Override
    public @Nullable I getInitialProcedure() {
        SymbolWrapper init = (SymbolWrapper)this.delegate.getInitialProcedure();
        return init == null ? null : (I)init.getDelegate();
    }

    @Override
    public ProceduralInputAlphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    @Override
    public Map<I, DFA<?, I>> getProcedures() {
        return this.procedures;
    }

    private class DFAView<S2>
    implements DFA<S2, I> {
        private final DFA<S2, SymbolWrapper<I>> delegate;

        DFAView(DFA<S2, SymbolWrapper<I>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Collection<S2> getStates() {
            return this.delegate.getStates();
        }

        @Override
        public @Nullable S2 getTransition(S2 s2, I i) {
            SymbolWrapper w = (SymbolWrapper)MappingSBA.this.mapping.get(i);
            return w == null ? null : (S2)this.delegate.getTransition(s2, w);
        }

        @Override
        public boolean isAccepting(S2 s2) {
            return this.delegate.isAccepting(s2);
        }

        @Override
        public @Nullable S2 getInitialState() {
            return (S2)this.delegate.getInitialState();
        }
    }
}

