/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.procedural.sba;

import de.learnlib.algorithm.procedural.SymbolWrapper;
import de.learnlib.algorithm.procedural.sba.ATManager;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

class ProceduralMembershipOracle<I>
implements MembershipOracle<SymbolWrapper<I>, Boolean> {
    private final ProceduralInputAlphabet<I> alphabet;
    private final MembershipOracle<I, Boolean> delegate;
    private final I procedure;
    private final ATManager<I> atManager;

    ProceduralMembershipOracle(ProceduralInputAlphabet<I> alphabet, MembershipOracle<I, Boolean> delegate, I procedure, ATManager<I> atManager) {
        this.alphabet = alphabet;
        this.delegate = delegate;
        this.procedure = procedure;
        this.atManager = atManager;
    }

    @Override
    public void processQueries(Collection<? extends Query<SymbolWrapper<I>, Boolean>> collection) {
        ArrayList<TransformedQuery> transformedQueries = new ArrayList<TransformedQuery>(collection.size());
        for (Query<SymbolWrapper<I>, Boolean> q : collection) {
            if (this.isWellDefined(q)) {
                transformedQueries.add(new TransformedQuery(q));
                continue;
            }
            q.answer(false);
        }
        this.delegate.processQueries(transformedQueries);
    }

    private boolean isWellDefined(Query<SymbolWrapper<I>, Boolean> q) {
        Iterator<SymbolWrapper<I>> iter = q.getInput().iterator();
        while (iter.hasNext()) {
            SymbolWrapper<I> wrapper = iter.next();
            if (wrapper.isContinuable()) continue;
            return !iter.hasNext();
        }
        return true;
    }

    private Word<I> transformLocalQuery(Word<SymbolWrapper<I>> query) {
        WordBuilder<I> builder = new WordBuilder<I>();
        builder.append(this.atManager.getAccessSequence(this.procedure));
        Iterator<SymbolWrapper<I>> iter = query.iterator();
        while (iter.hasNext()) {
            SymbolWrapper<I> w = iter.next();
            I i = w.getDelegate();
            builder.append(i);
            if (!this.alphabet.isCallSymbol(i) || !iter.hasNext()) continue;
            assert (w.isContinuable());
            builder.append(this.atManager.getTerminatingSequence(i));
            builder.append(this.alphabet.getReturnSymbol());
        }
        return builder.toWord();
    }

    private class TransformedQuery
    extends Query<I, Boolean> {
        private final Query<SymbolWrapper<I>, Boolean> originalQuery;
        private final Word<I> transformedQuery;

        TransformedQuery(Query<SymbolWrapper<I>, Boolean> originalQuery) {
            this.originalQuery = originalQuery;
            this.transformedQuery = ProceduralMembershipOracle.this.transformLocalQuery(originalQuery.getInput());
        }

        @Override
        public void answer(Boolean output) {
            this.originalQuery.answer(output);
        }

        @Override
        public Word<I> getPrefix() {
            return Word.epsilon();
        }

        @Override
        public Word<I> getSuffix() {
            return this.transformedQuery;
        }

        @Override
        public Word<I> getInput() {
            return this.transformedQuery;
        }
    }
}

