/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.procedural.sba;

import com.google.common.collect.Maps;
import de.learnlib.AccessSequenceTransformer;
import de.learnlib.acex.AbstractBaseCounterexample;
import de.learnlib.acex.AcexAnalyzer;
import de.learnlib.acex.AcexAnalyzers;
import de.learnlib.algorithm.LearnerConstructor;
import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.procedural.SymbolWrapper;
import de.learnlib.algorithm.procedural.sba.ATManager;
import de.learnlib.algorithm.procedural.sba.MappingSBA;
import de.learnlib.algorithm.procedural.sba.ProceduralMembershipOracle;
import de.learnlib.algorithm.procedural.sba.manager.OptimizingATManager;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import de.learnlib.util.MQUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.automatalib.alphabet.DefaultProceduralInputAlphabet;
import net.automatalib.alphabet.GrowingMapAlphabet;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.procedural.EmptySBA;
import net.automatalib.automaton.procedural.SBA;
import net.automatalib.automaton.procedural.StackSBA;
import net.automatalib.common.util.Pair;
import net.automatalib.common.util.mapping.Mapping;
import net.automatalib.util.automaton.Automata;
import net.automatalib.util.automaton.procedural.SBAs;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

public class SBALearner<I, L extends LearningAlgorithm.DFALearner<SymbolWrapper<I>> & SupportsGrowingAlphabet<SymbolWrapper<I>>>
implements LearningAlgorithm<SBA<?, I>, I, Boolean> {
    private final ProceduralInputAlphabet<I> alphabet;
    private final MembershipOracle<I, Boolean> oracle;
    private final Mapping<I, LearnerConstructor<L, SymbolWrapper<I>, Boolean>> learnerConstructors;
    private final AcexAnalyzer analyzer;
    private final ATManager<I> atManager;
    private final Map<I, L> learners;
    private I initialCallSymbol;
    private final Map<I, SymbolWrapper<I>> mapping;

    public SBALearner(ProceduralInputAlphabet<I> alphabet, MembershipOracle<I, Boolean> oracle, LearnerConstructor<L, SymbolWrapper<I>, Boolean> learnerConstructor) {
        this(alphabet, oracle, i -> learnerConstructor, AcexAnalyzers.BINARY_SEARCH_BWD, new OptimizingATManager<I>(alphabet));
    }

    public SBALearner(ProceduralInputAlphabet<I> alphabet, MembershipOracle<I, Boolean> oracle, Mapping<I, LearnerConstructor<L, SymbolWrapper<I>, Boolean>> learnerConstructors, AcexAnalyzer analyzer, ATManager<I> atManager) {
        this.alphabet = alphabet;
        this.oracle = oracle;
        this.learnerConstructors = learnerConstructors;
        this.analyzer = analyzer;
        this.atManager = atManager;
        this.learners = Maps.newHashMapWithExpectedSize(this.alphabet.getNumCalls());
        this.mapping = Maps.newHashMapWithExpectedSize(this.alphabet.size());
        for (Object i : this.alphabet.getInternalAlphabet()) {
            SymbolWrapper wrapper = new SymbolWrapper(i, true);
            this.mapping.put(i, wrapper);
        }
        SymbolWrapper<I> wrapper = new SymbolWrapper<I>(this.alphabet.getReturnSymbol(), false);
        this.mapping.put(this.alphabet.getReturnSymbol(), wrapper);
    }

    @Override
    public void startLearning() {
    }

    @Override
    public boolean refineHypothesis(DefaultQuery<I, Boolean> defaultQuery) {
        assert (this.alphabet.isReturnMatched(defaultQuery.getInput()));
        boolean changed = this.extractUsefulInformationFromCounterExample(defaultQuery);
        while (this.refineHypothesisInternal(defaultQuery)) {
            changed = true;
        }
        this.ensureCallAndReturnClosure();
        assert (SBAs.isValid(this.getHypothesisModel()));
        return changed;
    }

    private boolean refineHypothesisInternal(DefaultQuery<I, Boolean> defaultQuery) {
        Object hypothesis = this.getHypothesisModel();
        if (!MQUtil.isCounterexample(defaultQuery, hypothesis)) {
            return false;
        }
        Word input = defaultQuery.getInput();
        int mismatchIdx = this.analyzer.analyzeAbstractCounterexample(new Acex(input, defaultQuery.getOutput().booleanValue() ? ((SBA)hypothesis)::accepts : this.oracle::answerQuery));
        int callIdx = this.alphabet.findCallIndex(input, mismatchIdx);
        Object procedure = input.getSymbol(callIdx);
        Word<I> localTrace = this.alphabet.project(input.subWord(callIdx + 1, mismatchIdx), 0).append(input.getSymbol(mismatchIdx));
        DefaultQuery<SymbolWrapper<I>, Boolean> localCE = this.constructLocalCE(localTrace, defaultQuery.getOutput());
        boolean localRefinement = ((LearningAlgorithm.DFALearner)this.learners.get(procedure)).refineHypothesis(localCE);
        assert (localRefinement);
        return true;
    }

    @Override
    public SBA<?, I> getHypothesisModel() {
        SymbolWrapper<I> w;
        if (this.learners.isEmpty()) {
            return new EmptySBA<I>(this.alphabet);
        }
        GrowingMapAlphabet internalAlphabet = new GrowingMapAlphabet();
        GrowingMapAlphabet callAlphabet = new GrowingMapAlphabet();
        Map<I, DFA<?, SymbolWrapper<I>>> procedures = this.getSubModels();
        HashMap<SymbolWrapper<I>, DFA<?, SymbolWrapper<I>>> mappedProcedures = Maps.newHashMapWithExpectedSize(procedures.size());
        for (Map.Entry<I, DFA<?, SymbolWrapper<I>>> e : procedures.entrySet()) {
            w = this.mapping.get(e.getKey());
            assert (w != null);
            mappedProcedures.put(w, e.getValue());
            callAlphabet.add(w);
        }
        for (Map.Entry<Object, DFA<Object, SymbolWrapper<I>>> i : this.alphabet.getInternalAlphabet()) {
            w = this.mapping.get(i);
            assert (w != null);
            internalAlphabet.add(w);
        }
        SymbolWrapper<I> returnSymbol = this.mapping.get(this.alphabet.getReturnSymbol());
        assert (returnSymbol != null);
        DefaultProceduralInputAlphabet<SymbolWrapper<I>> mappedAlphabet = new DefaultProceduralInputAlphabet<SymbolWrapper<I>>(internalAlphabet, callAlphabet, returnSymbol);
        StackSBA delegate = new StackSBA(mappedAlphabet, this.mapping.get(this.initialCallSymbol), mappedProcedures);
        return new MappingSBA(this.alphabet, this.mapping, delegate);
    }

    private boolean extractUsefulInformationFromCounterExample(DefaultQuery<I, Boolean> defaultQuery) {
        if (!defaultQuery.getOutput().booleanValue()) {
            return false;
        }
        boolean update = false;
        Word input = defaultQuery.getInput();
        this.initialCallSymbol = input.firstSymbol();
        Pair<Set<I>, Set<I>> newSeqs = this.atManager.scanPositiveCounterexample(input);
        Set<I> newCalls = newSeqs.getFirst();
        Set<I> newTerms = newSeqs.getSecond();
        for (I call : newTerms) {
            SymbolWrapper<I> sym = new SymbolWrapper<I>(call, true);
            this.mapping.put(call, sym);
            for (Object learner : this.learners.values()) {
                ((SupportsGrowingAlphabet)learner).addAlphabetSymbol(sym);
                update = true;
            }
        }
        for (I sym : newCalls) {
            update = true;
            LearningAlgorithm.DFALearner newLearner = (LearningAlgorithm.DFALearner)this.learnerConstructors.get(sym).constructLearner(new GrowingMapAlphabet<SymbolWrapper<I>>(this.mapping.values()), new ProceduralMembershipOracle<I>(this.alphabet, this.oracle, sym, this.atManager));
            newLearner.startLearning();
            this.learners.put(sym, newLearner);
            Set<I> newTS = this.atManager.scanProcedures(Collections.singletonMap(sym, (DFA)newLearner.getHypothesisModel()), this.learners, this.mapping.values());
            for (Object call : newTS) {
                SymbolWrapper wrapper = new SymbolWrapper(call, true);
                this.mapping.put(call, wrapper);
                for (LearningAlgorithm.DFALearner learner : this.learners.values()) {
                    ((SupportsGrowingAlphabet)((Object)learner)).addAlphabetSymbol(wrapper);
                }
            }
            if (this.mapping.containsKey(sym)) continue;
            SymbolWrapper<I> wrapper = new SymbolWrapper<I>(sym, false);
            this.mapping.put(sym, wrapper);
            for (LearningAlgorithm.DFALearner learner : this.learners.values()) {
                ((SupportsGrowingAlphabet)((Object)learner)).addAlphabetSymbol(wrapper);
            }
        }
        return update;
    }

    private Map<I, DFA<?, SymbolWrapper<I>>> getSubModels() {
        HashMap<I, DFA> subModels = Maps.newHashMapWithExpectedSize(this.learners.size());
        for (Map.Entry<I, L> entry : this.learners.entrySet()) {
            subModels.put(entry.getKey(), (DFA)((LearningAlgorithm.DFALearner)entry.getValue()).getHypothesisModel());
        }
        return subModels;
    }

    private DefaultQuery<SymbolWrapper<I>, Boolean> constructLocalCE(Word<I> input, boolean output) {
        WordBuilder<SymbolWrapper<I>> wb = new WordBuilder<SymbolWrapper<I>>(input.length());
        for (I i : input) {
            wb.append(this.mapping.get(i));
        }
        return new DefaultQuery<SymbolWrapper<I>, Boolean>(wb.toWord(), output);
    }

    private void ensureCallAndReturnClosure() {
        HashSet<SymbolWrapper<I>> nonContinuableSymbols = new HashSet<SymbolWrapper<I>>();
        for (SymbolWrapper<I> mapped : this.mapping.values()) {
            if (mapped.isContinuable()) continue;
            nonContinuableSymbols.add(mapped);
        }
        for (LearningAlgorithm.DFALearner learner : this.learners.values()) {
            boolean stable = false;
            while (!stable) {
                stable = this.ensureCallAndReturnClosure((DFA)learner.getHypothesisModel(), nonContinuableSymbols, learner);
            }
        }
    }

    private <S> boolean ensureCallAndReturnClosure(DFA<S, SymbolWrapper<I>> hyp, Collection<SymbolWrapper<I>> nonContinuableSymbols, L learner) {
        HashSet<Word<SymbolWrapper<I>>> cover = new HashSet<Word<SymbolWrapper<I>>>();
        for (Word<SymbolWrapper<I>> word : Automata.stateCover(hyp, this.mapping.values())) {
            cover.add(((AccessSequenceTransformer)learner).transformAccessSequence(word));
        }
        for (Word<SymbolWrapper<Object>> word : cover) {
            Object state = hyp.getState(word);
            for (SymbolWrapper<I> i : nonContinuableSymbols) {
                Object succ = hyp.getSuccessor(state, i);
                for (SymbolWrapper<I> next : this.mapping.values()) {
                    if (!hyp.isAccepting(hyp.getSuccessor(succ, next))) continue;
                    DefaultQuery<SymbolWrapper<I>, Boolean> ce = new DefaultQuery<SymbolWrapper<I>, Boolean>(word.append(i).append(next), false);
                    boolean refined = learner.refineHypothesis(ce);
                    assert (refined);
                    return false;
                }
            }
        }
        return true;
    }

    private static class Acex<I>
    extends AbstractBaseCounterexample<Boolean> {
        private final Word<I> input;
        private final Predicate<? super Word<I>> oracle;

        Acex(Word<I> input, Predicate<? super Word<I>> oracle) {
            super(input.size() + 1);
            this.input = input;
            this.oracle = oracle;
        }

        @Override
        protected Boolean computeEffect(int index) {
            return this.oracle.test(this.input.prefix(index));
        }

        @Override
        public boolean checkEffects(Boolean eff1, Boolean eff2) {
            return Objects.equals(eff1, eff2);
        }
    }
}

