/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.procedural.spa;

import de.learnlib.algorithm.procedural.spa.ATRManager;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

class ProceduralMembershipOracle<I>
implements MembershipOracle<I, Boolean> {
    private final ProceduralInputAlphabet<I> alphabet;
    private final MembershipOracle<I, Boolean> delegate;
    private final I procedure;
    private final ATRManager<I> atrManager;

    ProceduralMembershipOracle(ProceduralInputAlphabet<I> alphabet, MembershipOracle<I, Boolean> delegate, I procedure, ATRManager<I> atrManager) {
        this.alphabet = alphabet;
        this.delegate = delegate;
        this.procedure = procedure;
        this.atrManager = atrManager;
    }

    @Override
    public void processQuery(Query<I, Boolean> query) {
        this.delegate.processQuery(new TransformedQuery(query));
    }

    @Override
    public void processQueries(Collection<? extends Query<I, Boolean>> collection) {
        ArrayList<TransformedQuery> transformedQueries = new ArrayList<TransformedQuery>(collection.size());
        for (Query<I, Boolean> q : collection) {
            transformedQueries.add(new TransformedQuery(q));
        }
        this.delegate.processQueries(transformedQueries);
    }

    private Word<I> transformLocalQuery(Word<I> query) {
        WordBuilder<I> builder = new WordBuilder<I>();
        builder.append(this.atrManager.getAccessSequence(this.procedure));
        for (I i : query) {
            if (this.alphabet.isInternalSymbol(i)) {
                builder.append(i);
                continue;
            }
            if (this.alphabet.isCallSymbol(i)) {
                builder.append(i);
                builder.append(this.atrManager.getTerminatingSequence(i));
                builder.append(this.alphabet.getReturnSymbol());
                continue;
            }
            throw new IllegalStateException("Systems should not query return symbol");
        }
        builder.append(this.atrManager.getReturnSequence(this.procedure));
        return builder.toWord();
    }

    private class TransformedQuery
    extends Query<I, Boolean> {
        private final Query<I, Boolean> originalQuery;
        private final Word<I> transformedQuery;

        TransformedQuery(Query<I, Boolean> originalQuery) {
            this.originalQuery = originalQuery;
            this.transformedQuery = ProceduralMembershipOracle.this.transformLocalQuery(originalQuery.getInput());
        }

        @Override
        public void answer(Boolean output) {
            this.originalQuery.answer(output);
        }

        @Override
        public Word<I> getPrefix() {
            return Word.epsilon();
        }

        @Override
        public Word<I> getSuffix() {
            return this.transformedQuery;
        }

        @Override
        public Word<I> getInput() {
            return this.transformedQuery;
        }
    }
}

