/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.discriminationtree.iterators;

import com.google.common.collect.Iterators;
import de.learnlib.datastructure.discriminationtree.iterators.NodeIterator;
import de.learnlib.datastructure.discriminationtree.model.AbstractDTNode;
import java.util.Iterator;
import java.util.function.Function;

public final class DiscriminationTreeIterators {
    private DiscriminationTreeIterators() {
    }

    public static <N extends AbstractDTNode<?, ?, ?, N>> Iterator<N> nodeIterator(N root) {
        return new NodeIterator<N>(root);
    }

    public static <N extends AbstractDTNode<?, ?, ?, N>> Iterator<N> innerNodeIterator(N root) {
        return Iterators.filter(DiscriminationTreeIterators.nodeIterator(root), n -> !n.isLeaf());
    }

    public static <N extends AbstractDTNode<?, ?, ?, N>> Iterator<N> leafIterator(N root) {
        return Iterators.filter(DiscriminationTreeIterators.nodeIterator(root), AbstractDTNode::isLeaf);
    }

    public static <N extends AbstractDTNode<?, ?, ?, N>, D> Iterator<D> transformingLeafIterator(N root, Function<? super N, D> transformer) {
        return Iterators.transform(DiscriminationTreeIterators.leafIterator(root), transformer::apply);
    }
}

