/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.pta.config;

import de.learnlib.datastructure.pta.AbstractBlueFringePTAState;
import de.learnlib.datastructure.pta.PTATransition;
import de.learnlib.datastructure.pta.config.ProcessingOrder;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;

public enum DefaultProcessingOrders implements ProcessingOrder
{
    CANONICAL_ORDER{

        @Override
        public <S extends AbstractBlueFringePTAState<S, ?, ?>> Queue<PTATransition<S>> createWorklist() {
            return new PriorityQueue<PTATransition<S>>(Comparator.comparing(PTATransition::getSource).thenComparingInt(PTATransition::getIndex));
        }
    }
    ,
    LEX_ORDER{

        @Override
        public <S extends AbstractBlueFringePTAState<S, ?, ?>> Queue<PTATransition<S>> createWorklist() {
            return new PriorityQueue<PTATransition<S>>(Comparator.comparing(PTATransition::getSource, AbstractBlueFringePTAState::lexCompareTo).thenComparingInt(PTATransition::getIndex));
        }
    }
    ,
    FIFO_ORDER{

        @Override
        public <S extends AbstractBlueFringePTAState<S, ?, ?>> Queue<PTATransition<S>> createWorklist() {
            return new ArrayDeque<PTATransition<S>>();
        }
    }
    ,
    LIFO_ORDER{

        @Override
        public <S extends AbstractBlueFringePTAState<S, ?, ?>> Queue<PTATransition<S>> createWorklist() {
            return Collections.asLifoQueue(new ArrayDeque());
        }
    };

}

