/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.mealy;

import de.learnlib.Resumable;
import de.learnlib.filter.cache.LearningCacheOracle;
import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.oracle.SymbolQueryOracle;
import de.learnlib.query.DefaultQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.transducer.CompactMealy;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.util.automaton.equivalence.NearLinearEquivalenceTest;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SymbolQueryCache<I, O>
implements SymbolQueryOracle<I, O>,
LearningCacheOracle.MealyLearningCacheOracle<I, O>,
Resumable<SymbolQueryCacheState<I, O>> {
    private CompactMealy<I, O> cache;
    private final SymbolQueryOracle<I, O> delegate;
    private final List<I> currentTrace;
    private Integer currentState;
    private boolean currentTraceValid;

    SymbolQueryCache(SymbolQueryOracle<I, O> delegate, Alphabet<I> alphabet) {
        this.delegate = delegate;
        this.cache = new CompactMealy(alphabet);
        this.currentState = (Integer)this.cache.addInitialState();
        this.currentTrace = new ArrayList<I>();
        this.currentTraceValid = false;
    }

    @Override
    public O query(I i) {
        Integer nextState;
        if (this.currentTraceValid) {
            Integer succ = this.cache.getSuccessor(this.currentState, i);
            if (succ != null) {
                Object output = this.cache.getOutput(this.currentState, i);
                assert (output != null);
                this.currentTrace.add(i);
                this.currentState = succ;
                return output;
            }
            this.currentTraceValid = false;
            this.delegate.reset();
            this.currentTrace.forEach(this.delegate::query);
        }
        O output = this.delegate.query(i);
        Integer succ = this.cache.getSuccessor(this.currentState, i);
        if (succ == null) {
            Integer newState = (Integer)this.cache.addState();
            this.cache.addTransition(this.currentState, i, newState, output);
            nextState = newState;
        } else {
            assert (Objects.equals(this.cache.getOutput(this.currentState, i), output));
            nextState = succ;
        }
        this.currentState = nextState;
        return output;
    }

    @Override
    public void reset() {
        Integer init = this.cache.getInitialState();
        assert (init != null);
        this.currentState = init;
        this.currentTrace.clear();
        this.currentTraceValid = true;
    }

    @Override
    public EquivalenceOracle<MealyMachine<?, I, ?, O>, I, Word<O>> createCacheConsistencyTest() {
        return this::findCounterexample;
    }

    private @Nullable DefaultQuery<I, Word<O>> findCounterexample(MealyMachine<?, I, ?, O> hypothesis, Collection<? extends I> alphabet) {
        Word<? extends I> sepWord = NearLinearEquivalenceTest.findSeparatingWord(this.cache, hypothesis, alphabet, true);
        if (sepWord != null) {
            return new DefaultQuery<I, Word>(sepWord, (Word)this.cache.computeOutput(sepWord));
        }
        return null;
    }

    @Override
    public SymbolQueryCacheState<I, O> suspend() {
        return new SymbolQueryCacheState<I, O>(this.cache);
    }

    @Override
    public void resume(SymbolQueryCacheState<I, O> state) {
        this.cache = state.getCache();
    }

    public static class SymbolQueryCacheState<I, O> {
        private final CompactMealy<I, O> cache;

        SymbolQueryCacheState(CompactMealy<I, O> cache) {
            this.cache = cache;
        }

        CompactMealy<I, O> getCache() {
            return this.cache;
        }
    }
}

