/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence;

import de.learnlib.oracle.BlackBoxOracle;
import de.learnlib.oracle.PropertyOracle;
import de.learnlib.query.DefaultQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.automatalib.automaton.concept.Output;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DisproveFirstOracle<A extends Output<I, D>, I, D>
implements BlackBoxOracle<A, I, D> {
    private final List<PropertyOracle<I, ? super A, ?, D>> propertyOracles;

    public DisproveFirstOracle() {
        this(Collections.emptyList());
    }

    public DisproveFirstOracle(PropertyOracle<I, ? super A, ?, D> propertyOracle) {
        this(Collections.singleton(propertyOracle));
    }

    public DisproveFirstOracle(Collection<? extends PropertyOracle<I, ? super A, ?, D>> propertyOracles) {
        this.propertyOracles = new ArrayList(propertyOracles);
    }

    @Override
    public List<PropertyOracle<I, ? super A, ?, D>> getPropertyOracles() {
        return this.propertyOracles;
    }

    @Override
    public @Nullable DefaultQuery<I, D> findCounterExample(A hypothesis, Collection<? extends I> inputs) {
        for (PropertyOracle<? extends I, A, ?, D> propertyOracle : this.propertyOracles) {
            if (propertyOracle.isDisproved()) continue;
            propertyOracle.disprove(hypothesis, inputs);
        }
        for (PropertyOracle<? extends I, A, ?, D> propertyOracle : this.propertyOracles) {
            DefaultQuery<I, D> ce;
            if (propertyOracle.isDisproved() || (ce = propertyOracle.doFindCounterExample(hypothesis, inputs)) == null) continue;
            assert (this.isCounterExample(hypothesis, ce.getInput(), ce.getOutput()));
            return ce;
        }
        return null;
    }
}

