/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence.mealy;

import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.query.DefaultQuery;
import java.util.Collection;
import java.util.Objects;
import net.automatalib.automaton.concept.DetSuffixOutputAutomaton;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SymbolEQOracleWrapper<A extends DetSuffixOutputAutomaton<?, I, ?, Word<O>>, I, O>
implements EquivalenceOracle<A, I, O> {
    private final EquivalenceOracle<? super A, I, Word<O>> wordEqOracle;

    public SymbolEQOracleWrapper(EquivalenceOracle<? super A, I, Word<O>> wordEqOracle) {
        this.wordEqOracle = wordEqOracle;
    }

    @Override
    public @Nullable DefaultQuery<I, O> findCounterExample(A hypothesis, Collection<? extends I> inputs) {
        DefaultQuery<I, Word<O>> wordCeQry = this.wordEqOracle.findCounterExample(hypothesis, inputs);
        if (wordCeQry == null) {
            return null;
        }
        Word hypOut = (Word)hypothesis.computeSuffixOutput(wordCeQry.getPrefix(), wordCeQry.getSuffix());
        Word<O> ceOut = wordCeQry.getOutput();
        int len = hypOut.length();
        if (len != ceOut.length()) {
            throw new IllegalStateException("Output word length does not align with suffix length, truncating CE will not work");
        }
        for (int i = 0; i < len; ++i) {
            O ceSym;
            Object hypSym = hypOut.getSymbol(i);
            if (Objects.equals(hypSym, ceSym = ceOut.getSymbol(i))) continue;
            DefaultQuery result = new DefaultQuery(wordCeQry.getPrefix(), wordCeQry.getSuffix().prefix(i + 1));
            result.answer(ceSym);
            return result;
        }
        throw new IllegalStateException("Counterexample returned by underlying EQ oracle was none");
    }
}

