/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.membership;

import de.learnlib.oracle.MembershipOracle;
import de.learnlib.oracle.SingleQueryOmegaOracle;
import de.learnlib.oracle.membership.DFASimulatorOracle;
import de.learnlib.oracle.membership.MealySimulatorOracle;
import de.learnlib.oracle.membership.SimulatorOracle;
import de.learnlib.query.OmegaQuery;
import de.learnlib.util.MQUtil;
import java.util.ArrayList;
import java.util.Collection;
import net.automatalib.automaton.concept.SuffixOutput;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.util.Pair;
import net.automatalib.ts.simple.SimpleDTS;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimulatorOmegaOracle<S, I, D>
implements SingleQueryOmegaOracle<S, I, D> {
    private final SimpleDTS<S, I> simpleDTS;
    private final SimulatorOracle<I, D> simulatorOracle;

    public <A extends SuffixOutput<I, D> & SimpleDTS<S, I>> SimulatorOmegaOracle(A automaton, SimulatorOracle<I, D> simulatorOracle) {
        this.simpleDTS = automaton;
        this.simulatorOracle = simulatorOracle;
    }

    @Override
    public MembershipOracle<I, D> getMembershipOracle() {
        return this.simulatorOracle;
    }

    @Override
    public boolean isSameState(Word<I> input1, S s1, Word<I> input2, S s2) {
        return s1.equals(s2);
    }

    @Override
    public void processQueries(Collection<? extends OmegaQuery<I, D>> queries) {
        MQUtil.answerOmegaQueries(this, queries);
    }

    @Override
    public Pair<@Nullable D, Integer> answerQuery(Word<I> prefix, Word<I> loop, int repeat) {
        assert (repeat > 0);
        WordBuilder<I> wb = new WordBuilder<I>(prefix.length() + loop.length() * repeat, prefix);
        S stateIter = this.simpleDTS.getState(wb);
        if (stateIter == null) {
            return Pair.of(null, -1);
        }
        ArrayList<S> states = new ArrayList<S>(repeat + 1);
        states.add(stateIter);
        for (int i = 0; i < repeat; ++i) {
            S nextState = this.simpleDTS.getSuccessor(stateIter, loop);
            if (nextState == null) {
                return Pair.of(null, -1);
            }
            wb.append(loop);
            int prefixLength = prefix.length();
            for (Object s2 : states) {
                if (this.isSameState(wb.toWord(0, prefixLength), s2, wb.toWord(), nextState)) {
                    return Pair.of(this.simulatorOracle.answerQuery(wb.toWord()), i + 1);
                }
                prefixLength += loop.length();
            }
            states.add(nextState);
            stateIter = nextState;
        }
        return Pair.of(null, -1);
    }

    public static class MealySimulatorOmegaOracle<S, I, O>
    extends SimulatorOmegaOracle<S, I, Word<O>>
    implements SingleQueryOmegaOracle.SingleQueryOmegaOracleMealy<S, I, O> {
        private final MealyMachine<?, I, ?, O> automaton;

        public MealySimulatorOmegaOracle(MealyMachine<S, I, ?, O> automaton) {
            super(automaton, new MealySimulatorOracle<I, O>(automaton));
            this.automaton = automaton;
        }

        @Override
        public MembershipOracle.MealyMembershipOracle<I, O> getMembershipOracle() {
            return new MealySimulatorOracle<I, O>(this.automaton);
        }
    }

    public static class DFASimulatorOmegaOracle<S, I>
    extends SimulatorOmegaOracle<S, I, Boolean>
    implements SingleQueryOmegaOracle.SingleQueryOmegaOracleDFA<S, I> {
        private final DFA<S, I> automaton;

        public DFASimulatorOmegaOracle(DFA<S, I> automaton) {
            super(automaton, new DFASimulatorOracle<I>(automaton));
            this.automaton = automaton;
        }

        @Override
        public MembershipOracle.DFAMembershipOracle<I> getMembershipOracle() {
            return new DFASimulatorOracle<I>(this.automaton);
        }
    }
}

