/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.setting;

import de.learnlib.logging.Category;
import de.learnlib.setting.LearnLibProperty;
import de.learnlib.setting.LearnLibSettingsSource;
import java.util.Locale;
import java.util.Properties;
import java.util.function.Function;
import net.automatalib.common.util.WrapperUtil;
import net.automatalib.common.util.setting.SettingsSource;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LearnLibSettings {
    private static final Logger LOG = LoggerFactory.getLogger(LearnLibSettings.class);
    private static final LearnLibSettings INSTANCE = new LearnLibSettings();
    private final Properties properties = SettingsSource.readSettings(LearnLibSettingsSource.class);

    private LearnLibSettings() {
    }

    public static LearnLibSettings getInstance() {
        return INSTANCE;
    }

    public String getProperty(LearnLibProperty property, String defaultValue) {
        return this.properties.getProperty(property.getPropertyKey(), defaultValue);
    }

    public @Nullable String getProperty(LearnLibProperty property) {
        return this.properties.getProperty(property.getPropertyKey());
    }

    public <E extends Enum<E>> E getEnumValue(LearnLibProperty property, Class<E> enumClazz, E defaultValue) {
        E value = this.getEnumValue(property, enumClazz);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public <E extends Enum<E>> @Nullable E getEnumValue(LearnLibProperty property, Class<E> enumClazz) {
        return (E)this.getTypedValue(property, p -> Enum.valueOf(enumClazz, p.toUpperCase(Locale.ROOT)));
    }

    public boolean getBool(LearnLibProperty property, boolean defaultValue) {
        return WrapperUtil.booleanValue(this.getBoolean(property), defaultValue);
    }

    public @Nullable Boolean getBoolean(LearnLibProperty property) {
        return this.getTypedValue(property, Boolean::parseBoolean);
    }

    public int getInt(LearnLibProperty property, int defaultValue) {
        return WrapperUtil.intValue(this.getInteger(property), defaultValue);
    }

    public @Nullable Integer getInteger(LearnLibProperty property) {
        return this.getTypedValue(property, Integer::parseInt);
    }

    private <T> @Nullable T getTypedValue(LearnLibProperty property, Function<String, T> valueExtractor) {
        String prop = this.getProperty(property);
        if (prop == null) {
            return null;
        }
        try {
            return valueExtractor.apply(prop);
        }
        catch (IllegalArgumentException ex) {
            LOG.warn(Category.CONFIG, "Could not parse LearnLib property '" + (Object)((Object)property) + "'.", ex);
            return null;
        }
    }
}

