/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.util;

import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.filter.statistic.Counter;
import de.learnlib.logging.Category;
import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.query.DefaultQuery;
import de.learnlib.util.statistic.SimpleProfiler;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.automaton.transducer.MooreMachine;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Experiment<A> {
    public static final String LEARNING_PROFILE_KEY = "Learning";
    public static final String COUNTEREXAMPLE_PROFILE_KEY = "Searching for counterexample";
    private static final Logger LOGGER = LoggerFactory.getLogger(Experiment.class);
    private final ExperimentImpl<?, ?> impl;
    private boolean logModels;
    private boolean profile;
    private final Counter rounds = new Counter("Learning rounds", "#");
    private @Nullable A finalHypothesis;

    public <I, D> Experiment(LearningAlgorithm<? extends A, I, D> learningAlgorithm, EquivalenceOracle<? super A, I, D> equivalenceAlgorithm, Alphabet<I> inputs) {
        this.impl = new ExperimentImpl<I, D>(learningAlgorithm, equivalenceAlgorithm, inputs);
    }

    public A run() {
        if (this.finalHypothesis != null) {
            throw new IllegalStateException("Experiment has already been run");
        }
        this.finalHypothesis = this.impl.run();
        return this.finalHypothesis;
    }

    public A getFinalHypothesis() {
        if (this.finalHypothesis == null) {
            throw new IllegalStateException("Experiment has not yet been run");
        }
        return this.finalHypothesis;
    }

    private void profileStart(String taskname) {
        if (this.profile) {
            SimpleProfiler.start(taskname);
        }
    }

    private void profileStop(String taskname) {
        if (this.profile) {
            SimpleProfiler.stop(taskname);
        }
    }

    public void setLogModels(boolean logModels) {
        this.logModels = logModels;
    }

    public void setProfile(boolean profile) {
        this.profile = profile;
    }

    public Counter getRounds() {
        return this.rounds;
    }

    public static class MooreExperiment<I, O>
    extends Experiment<MooreMachine<?, I, ?, O>> {
        public MooreExperiment(LearningAlgorithm<? extends MooreMachine<?, I, ?, O>, I, Word<O>> learningAlgorithm, EquivalenceOracle<? super MooreMachine<?, I, ?, O>, I, Word<O>> equivalenceAlgorithm, Alphabet<I> inputs) {
            super(learningAlgorithm, equivalenceAlgorithm, inputs);
        }
    }

    public static class MealyExperiment<I, O>
    extends Experiment<MealyMachine<?, I, ?, O>> {
        public MealyExperiment(LearningAlgorithm<? extends MealyMachine<?, I, ?, O>, I, Word<O>> learningAlgorithm, EquivalenceOracle<? super MealyMachine<?, I, ?, O>, I, Word<O>> equivalenceAlgorithm, Alphabet<I> inputs) {
            super(learningAlgorithm, equivalenceAlgorithm, inputs);
        }
    }

    public static class DFAExperiment<I>
    extends Experiment<DFA<?, I>> {
        public DFAExperiment(LearningAlgorithm<? extends DFA<?, I>, I, Boolean> learningAlgorithm, EquivalenceOracle<? super DFA<?, I>, I, Boolean> equivalenceAlgorithm, Alphabet<I> inputs) {
            super(learningAlgorithm, equivalenceAlgorithm, inputs);
        }
    }

    private final class ExperimentImpl<I, D> {
        private final LearningAlgorithm<? extends A, I, D> learningAlgorithm;
        private final EquivalenceOracle<? super A, I, D> equivalenceAlgorithm;
        private final Alphabet<I> inputs;

        ExperimentImpl(LearningAlgorithm<? extends A, I, D> learningAlgorithm, EquivalenceOracle<? super A, I, D> equivalenceAlgorithm, Alphabet<I> inputs) {
            this.learningAlgorithm = learningAlgorithm;
            this.equivalenceAlgorithm = equivalenceAlgorithm;
            this.inputs = inputs;
        }

        public A run() {
            boolean refined;
            Experiment.this.rounds.increment();
            LOGGER.info(Category.PHASE, "Starting round {}", (Object)Experiment.this.rounds.getCount());
            LOGGER.info(Category.PHASE, Experiment.LEARNING_PROFILE_KEY);
            Experiment.this.profileStart(Experiment.LEARNING_PROFILE_KEY);
            this.learningAlgorithm.startLearning();
            Experiment.this.profileStop(Experiment.LEARNING_PROFILE_KEY);
            while (true) {
                Object hyp = this.learningAlgorithm.getHypothesisModel();
                if (Experiment.this.logModels) {
                    LOGGER.info(Category.MODEL, hyp.toString());
                }
                LOGGER.info(Category.PHASE, Experiment.COUNTEREXAMPLE_PROFILE_KEY);
                Experiment.this.profileStart(Experiment.COUNTEREXAMPLE_PROFILE_KEY);
                DefaultQuery<I, D> ce = this.equivalenceAlgorithm.findCounterExample(hyp, this.inputs);
                Experiment.this.profileStop(Experiment.COUNTEREXAMPLE_PROFILE_KEY);
                if (ce == null) {
                    return hyp;
                }
                LOGGER.info(Category.COUNTEREXAMPLE, ce.getInput().toString());
                Experiment.this.rounds.increment();
                LOGGER.info(Category.PHASE, "Starting round {}", (Object)Experiment.this.rounds.getCount());
                LOGGER.info(Category.PHASE, Experiment.LEARNING_PROFILE_KEY);
                Experiment.this.profileStart(Experiment.LEARNING_PROFILE_KEY);
                refined = this.learningAlgorithm.refineHypothesis(ce);
                Experiment.this.profileStop(Experiment.LEARNING_PROFILE_KEY);
                assert (refined);
            }
        }
    }
}

