/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.util.mealy;

import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.query.DefaultQuery;
import de.learnlib.util.mealy.MealyUtil;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.word.Word;

final class MealyLearnerWrapper<M extends MealyMachine<?, I, ?, O>, I, O>
implements LearningAlgorithm.MealyLearner<I, O> {
    private final LearningAlgorithm<M, I, O> learner;

    MealyLearnerWrapper(LearningAlgorithm<M, I, O> learner) {
        this.learner = learner;
    }

    @Override
    public void startLearning() {
        this.learner.startLearning();
    }

    @Override
    public boolean refineHypothesis(DefaultQuery<I, Word<O>> ceQuery) {
        MealyMachine hyp = (MealyMachine)this.learner.getHypothesisModel();
        DefaultQuery<I, O> reducedQry = MealyUtil.reduceCounterExample(hyp, ceQuery);
        return reducedQry != null && this.learner.refineHypothesis(reducedQry);
    }

    @Override
    public M getHypothesisModel() {
        return (M)((MealyMachine)this.learner.getHypothesisModel());
    }
}

