/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.generators.GraphGenerator;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.util.ArrayList;
import java.util.List;

public class Lattice2DGenerator<V, E>
implements GraphGenerator<V, E> {
    protected int row_count;
    protected int col_count;
    protected boolean is_toroidal;
    protected boolean is_directed;
    protected Supplier<? extends Graph<V, E>> graph_factory;
    protected Supplier<V> vertex_factory;
    protected Supplier<E> edge_factory;
    private List<V> v_array;

    public Lattice2DGenerator(Supplier<? extends Graph<V, E>> graph_factory, Supplier<V> vertex_factory, Supplier<E> edge_factory, int latticeSize, boolean isToroidal) {
        this(graph_factory, vertex_factory, edge_factory, latticeSize, latticeSize, isToroidal);
    }

    public Lattice2DGenerator(Supplier<? extends Graph<V, E>> graph_factory, Supplier<V> vertex_factory, Supplier<E> edge_factory, int row_count, int col_count, boolean isToroidal) {
        if (row_count < 2 || col_count < 2) {
            throw new IllegalArgumentException("Row and column counts must each be at least 2.");
        }
        this.row_count = row_count;
        this.col_count = col_count;
        this.is_toroidal = isToroidal;
        this.graph_factory = graph_factory;
        this.vertex_factory = vertex_factory;
        this.edge_factory = edge_factory;
        this.is_directed = graph_factory.get().getDefaultEdgeType() == EdgeType.DIRECTED;
    }

    @Override
    public Graph<V, E> get() {
        int j;
        int i;
        int vertex_count = this.row_count * this.col_count;
        Graph<V, E> graph = this.graph_factory.get();
        this.v_array = new ArrayList<V>(vertex_count);
        for (int i2 = 0; i2 < vertex_count; ++i2) {
            V v = this.vertex_factory.get();
            graph.addVertex(v);
            this.v_array.add(i2, v);
        }
        int start = this.is_toroidal ? 0 : 1;
        int end_row = this.is_toroidal ? this.row_count : this.row_count - 1;
        int end_col = this.is_toroidal ? this.col_count : this.col_count - 1;
        for (i = 0; i < end_row; ++i) {
            for (j = 0; j < this.col_count; ++j) {
                graph.addEdge(this.edge_factory.get(), this.getVertex(i, j), this.getVertex(i + 1, j));
            }
        }
        for (i = 0; i < this.row_count; ++i) {
            for (j = 0; j < end_col; ++j) {
                graph.addEdge(this.edge_factory.get(), this.getVertex(i, j), this.getVertex(i, j + 1));
            }
        }
        if (graph.getDefaultEdgeType() == EdgeType.DIRECTED) {
            for (i = start; i < this.row_count; ++i) {
                for (j = 0; j < this.col_count; ++j) {
                    graph.addEdge(this.edge_factory.get(), this.getVertex(i, j), this.getVertex(i - 1, j));
                }
            }
            for (i = 0; i < this.row_count; ++i) {
                for (j = start; j < this.col_count; ++j) {
                    graph.addEdge(this.edge_factory.get(), this.getVertex(i, j), this.getVertex(i, j - 1));
                }
            }
        }
        return graph;
    }

    public int getGridEdgeCount() {
        int boundary_adjustment = this.is_toroidal ? 0 : 1;
        int vertical_edge_count = this.col_count * (this.row_count - boundary_adjustment);
        int horizontal_edge_count = this.row_count * (this.col_count - boundary_adjustment);
        return (vertical_edge_count + horizontal_edge_count) * (this.is_directed ? 2 : 1);
    }

    protected int getIndex(int i, int j) {
        return this.mod(i, this.row_count) * this.col_count + this.mod(j, this.col_count);
    }

    protected int mod(int i, int modulus) {
        int i_mod = i % modulus;
        return i_mod >= 0 ? i_mod : i_mod + modulus;
    }

    protected V getVertex(int i, int j) {
        return this.v_array.get(this.getIndex(i, j));
    }

    protected V getVertex(int i) {
        return this.v_array.get(i);
    }

    protected int getRow(int i) {
        return i / this.col_count;
    }

    protected int getCol(int i) {
        return i % this.col_count;
    }
}

