/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd.xdd.grouplikedd.example;

import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Permutation {
    private final int[] p;

    public Permutation(int ... p) {
        this.p = p;
    }

    public static Permutation identity(int n) {
        int[] p = new int[n];
        for (int i = 0; i < n; ++i) {
            p[i] = i;
        }
        return new Permutation(p);
    }

    public static Permutation parsePermutation(String str) {
        int[] p;
        if (str.isEmpty()) {
            p = new int[]{};
        } else {
            String[] strMaps = str.split(", ");
            p = new int[strMaps.length];
            for (int i = 0; i < strMaps.length; ++i) {
                String strTo = strMaps[i].split(" -> ")[1];
                p[i] = Integer.parseInt(strTo);
            }
        }
        return new Permutation(p);
    }

    public int size() {
        return this.p.length;
    }

    public int[] data() {
        return (int[])this.p.clone();
    }

    public Permutation compose(Permutation g2) {
        int[] pComposed = new int[this.p.length];
        for (int i = 0; i < this.p.length; ++i) {
            pComposed[i] = this.p[g2.p[i]];
        }
        return new Permutation(pComposed);
    }

    public Permutation inverse() {
        int[] pInverse = new int[this.p.length];
        for (int i = 0; i < this.p.length; ++i) {
            pInverse[this.p[i]] = i;
        }
        return new Permutation(pInverse);
    }

    public boolean equals(@Nullable Object otherObj) {
        if (otherObj instanceof Permutation) {
            Permutation other = (Permutation)otherObj;
            return Arrays.equals(this.p, other.p);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.p);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        if (i < this.p.length) {
            sb.append(i + " -> " + this.p[i++]);
        }
        while (i < this.p.length) {
            sb.append(", " + i + " -> " + this.p[i++]);
        }
        return sb.toString();
    }
}

