/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd.xdd.latticedd.example;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Multiset<E> {
    private final Map<E, Integer> multiplicity;

    public Multiset(E ... elements) {
        this.multiplicity = new HashMap<E, Integer>();
        for (E e : elements) {
            Integer value = this.multiplicity.get(e);
            if (value != null) {
                this.multiplicity.put(e, value + 1);
                continue;
            }
            this.multiplicity.put(e, 1);
        }
    }

    private Multiset(Map<E, Integer> multiplicity) {
        this.multiplicity = multiplicity;
    }

    public static <E> Multiset<E> emptySet() {
        return new Multiset(new HashMap());
    }

    public static <E> Multiset<E> parseMultiset(String str, Function<String, E> parseElement) {
        String commaSeparatedMults = str.substring(1, str.length() - 1);
        String[] strMults = commaSeparatedMults.split(", ");
        HashMap<E, Integer> multiplicity = new HashMap<E, Integer>();
        for (String strMult : strMults) {
            if (strMult.isEmpty()) continue;
            String[] strMultPair = strMult.split(": ");
            E parsed = parseElement.apply(strMultPair[0]);
            int n = Integer.parseInt(strMultPair[1]);
            multiplicity.put(parsed, n);
        }
        return new Multiset(multiplicity);
    }

    public Map<E, Integer> multiplicity() {
        return new HashMap<E, Integer>(this.multiplicity);
    }

    public Multiset<E> intersect(Multiset<E> other) {
        HashMap<E, Integer> intersection = new HashMap<E, Integer>();
        for (Map.Entry<E, Integer> entry : this.multiplicity.entrySet()) {
            Integer otherValue = other.multiplicity.get(entry.getKey());
            if (otherValue == null) continue;
            intersection.put(entry.getKey(), Math.min(entry.getValue(), otherValue));
        }
        return new Multiset(intersection);
    }

    public Multiset<E> union(Multiset<E> other) {
        HashMap<Object, Integer> union = new HashMap<Object, Integer>();
        for (Map.Entry<E, Integer> entry : this.multiplicity.entrySet()) {
            Integer otherValue = other.multiplicity.get(entry.getKey());
            if (otherValue != null) {
                union.put(entry.getKey(), Math.max(entry.getValue(), otherValue));
                continue;
            }
            union.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Integer> e : other.multiplicity.keySet()) {
            if (this.multiplicity.containsKey(e)) continue;
            union.put(e, other.multiplicity.get(e));
        }
        return new Multiset(union);
    }

    public boolean includes(Multiset<E> other) {
        for (Map.Entry<E, Integer> entry : this.multiplicity.entrySet()) {
            Integer otherValue = other.multiplicity.get(entry.getKey());
            if (otherValue == null || otherValue <= entry.getValue()) continue;
            return false;
        }
        for (Map.Entry<Object, Integer> e : other.multiplicity.keySet()) {
            if (this.multiplicity.containsKey(e)) continue;
            return false;
        }
        return true;
    }

    public Multiset<E> plus(Multiset<E> other) {
        HashMap<Object, Integer> sum = new HashMap<Object, Integer>();
        for (Map.Entry<E, Integer> entry : this.multiplicity.entrySet()) {
            Integer otherValue = other.multiplicity.get(entry.getKey());
            if (otherValue != null) {
                sum.put(entry.getKey(), entry.getValue() + otherValue);
                continue;
            }
            sum.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Integer> e : other.multiplicity.keySet()) {
            if (this.multiplicity.containsKey(e)) continue;
            sum.put(e, other.multiplicity.get(e));
        }
        return new Multiset(sum);
    }

    public int size() {
        int size = 0;
        for (int n : this.multiplicity.values()) {
            size += n;
        }
        return size;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Multiset multiset = (Multiset)o;
        return Objects.equals(this.multiplicity, multiset.multiplicity);
    }

    public int hashCode() {
        return Objects.hash(this.multiplicity);
    }

    public String toString() {
        String strCommaSeparated = this.multiplicity.entrySet().stream().map(e -> e.getKey() + ": " + e.getValue()).collect(Collectors.joining(", "));
        return "[" + strCommaSeparated + "]";
    }
}

