/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd.xdd.ringlikedd.example;

import info.scce.addlib.backend.ADDBackend;
import info.scce.addlib.backend.BackendProvider;
import info.scce.addlib.dd.xdd.ringlikedd.SemiringDDManager;
import java.awt.Color;

public class ColorDDManager
extends SemiringDDManager<Color> {
    private static final int COLOR_RANGE = 255;
    private static final double RED_GRAY_PROPORTION = 0.2126;
    private static final double GREEN_GRAY_PROPORTION = 0.7152;
    private static final double BLUE_GRAY_PROPORTION = 0.0722;

    public ColorDDManager() {
        this(BackendProvider.getADDBackend());
    }

    public ColorDDManager(ADDBackend backend) {
        super(backend);
    }

    @Override
    protected Color zeroElement() {
        return new Color(0, 0, 0);
    }

    @Override
    protected Color oneElement() {
        return new Color(255, 255, 255);
    }

    @Override
    protected Color mult(Color color0, Color color1) {
        int r = color0.getRed() * color1.getRed() / 255;
        int g2 = color0.getGreen() * color1.getGreen() / 255;
        int b = color0.getBlue() * color1.getBlue() / 255;
        return new Color(r, g2, b);
    }

    @Override
    protected Color add(Color color0, Color color1) {
        int r = Math.min(color0.getRed() + color1.getRed(), 255);
        int g2 = Math.min(color0.getGreen() + color1.getGreen(), 255);
        int b = Math.min(color0.getBlue() + color1.getBlue(), 255);
        return new Color(r, g2, b);
    }

    public static Color avg(Color color0, Color color1) {
        int r = (color0.getRed() + color1.getRed()) / 2;
        int g2 = (color0.getGreen() + color1.getGreen()) / 2;
        int b = (color0.getBlue() + color1.getBlue()) / 2;
        return new Color(r, g2, b);
    }

    public static Color grayscale(Color color) {
        int gray = (int)Math.round(0.2126 * (double)color.getRed() + 0.7152 * (double)color.getGreen() + 0.0722 * (double)color.getBlue());
        return new Color(gray, gray, gray);
    }
}

