/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.alphabet;

import java.util.ArrayList;
import java.util.List;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.MapAlphabet;
import net.automatalib.alphabet.ProceduralOutputAlphabet;

public class DefaultProceduralOutputAlphabet<O>
extends MapAlphabet<O>
implements ProceduralOutputAlphabet<O> {
    private final Alphabet<O> regularAlphabet;
    private final O errorSymbol;

    public DefaultProceduralOutputAlphabet(Alphabet<O> regularAlphabet, O errorSymbol) {
        super(DefaultProceduralOutputAlphabet.buildCombinedAlphabet(regularAlphabet, errorSymbol));
        this.regularAlphabet = regularAlphabet;
        this.errorSymbol = errorSymbol;
    }

    private static <O> List<O> buildCombinedAlphabet(Alphabet<O> internalOutputs, O errorSymbol) {
        ArrayList<O> result = new ArrayList<O>(internalOutputs.size() + 1);
        result.addAll(internalOutputs);
        result.add(errorSymbol);
        return result;
    }

    @Override
    public Alphabet<O> getRegularAlphabet() {
        return this.regularAlphabet;
    }

    @Override
    public O getErrorSymbol() {
        return this.errorSymbol;
    }
}

