/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CompactTransition<TP> {
    private int memoryIdx;
    private final int succId;
    private TP property;

    public CompactTransition(int succId, TP property) {
        this(-1, succId, property);
    }

    public CompactTransition(int memoryIdx, int succId, TP property) {
        this.memoryIdx = memoryIdx;
        this.succId = succId;
        this.property = property;
    }

    public int getSuccId() {
        return this.succId;
    }

    public TP getProperty() {
        return this.property;
    }

    public void setProperty(TP property) {
        this.property = property;
    }

    public int getMemoryIdx() {
        return this.memoryIdx;
    }

    public void setMemoryIdx(int memoryIdx) {
        this.memoryIdx = memoryIdx;
    }

    public boolean isAutomatonTransition() {
        return this.memoryIdx >= 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompactTransition)) {
            return false;
        }
        CompactTransition that = (CompactTransition)o;
        return this.memoryIdx == that.memoryIdx && this.succId == that.succId && Objects.equals(this.property, that.property);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Integer.hashCode(this.memoryIdx);
        result = 31 * result + Integer.hashCode(this.succId);
        result = 31 * result + Objects.hashCode(this.property);
        return result;
    }
}

