/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.abstraction;

import java.util.function.IntFunction;
import net.automatalib.automaton.DeterministicAutomaton;
import net.automatalib.automaton.abstraction.SimpleDeterministicAbstractions;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface DeterministicAbstractions {

    public static class FullIntAbstraction<I, T, A extends DeterministicAutomaton.StateIntAbstraction<I, T>>
    extends SimpleDeterministicAbstractions.FullIntAbstraction<I, A>
    implements DeterministicAutomaton.FullIntAbstraction<T> {
        public FullIntAbstraction(A stateAbstraction, int numInputs, IntFunction<? extends I> symMapping) {
            super(stateAbstraction, numInputs, symMapping);
        }

        @Override
        public @Nullable T getTransition(int state, int input) {
            return ((DeterministicAutomaton.StateIntAbstraction)this.stateAbstraction).getTransition(state, this.intToSym(input));
        }

        @Override
        public int getIntSuccessor(T transition) {
            return ((DeterministicAutomaton.StateIntAbstraction)this.stateAbstraction).getIntSuccessor(transition);
        }
    }

    public static class StateIntAbstraction<S, I, T, A extends DeterministicAutomaton<S, I, T>>
    extends SimpleDeterministicAbstractions.StateIntAbstraction<S, I, A>
    implements DeterministicAutomaton.StateIntAbstraction<I, T> {
        public StateIntAbstraction(A automaton) {
            super(automaton);
        }

        @Override
        public int getIntSuccessor(T transition) {
            return this.stateToInt(((DeterministicAutomaton)this.automaton).getSuccessor(transition));
        }

        @Override
        public @Nullable T getTransition(int state, I input) {
            return ((DeterministicAutomaton)this.automaton).getTransition(this.intToState(state), input);
        }
    }
}

