/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.procedural;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.procedural.SPMM;
import net.automatalib.automaton.procedural.StackState;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.automaton.transducer.MealyTransition;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StackSPMM<S, I, T, O>
implements SPMM<StackState<S, I, MealyMachine<S, I, T, O>>, I, MealyTransition<StackState<S, I, MealyMachine<S, I, T, O>>, O>, O> {
    private final ProceduralInputAlphabet<I> alphabet;
    private final O errorOutput;
    private final @Nullable I initialCall;
    private final O initialOutput;
    private final Map<I, MealyMachine<S, I, T, O>> procedures;

    public StackSPMM(ProceduralInputAlphabet<I> alphabet, @Nullable I initialCall, O initialOutput, O errorOutput, Map<I, ? extends MealyMachine<? extends S, I, ? extends T, O>> procedures) {
        this.alphabet = alphabet;
        this.errorOutput = errorOutput;
        this.initialCall = initialCall;
        this.initialOutput = initialOutput;
        this.procedures = procedures;
    }

    @Override
    public MealyTransition<StackState<S, I, MealyMachine<S, I, T, O>>, O> getTransition(StackState<S, I, MealyMachine<S, I, T, O>> state, I input) {
        if (state.isSink() || state.isTerm()) {
            return this.sink();
        }
        if (this.alphabet.isInternalSymbol(input)) {
            if (state.isInit()) {
                return this.sink();
            }
            MealyMachine model = state.getProcedure();
            Object t = model.getTransition(state.getCurrentState(), input);
            if (t == null || this.isErrorOutput(model.getTransitionOutput(t))) {
                return this.sink();
            }
            return new MealyTransition(state.updateState(model.getSuccessor(t)), model.getTransitionOutput(t));
        }
        if (this.alphabet.isCallSymbol(input)) {
            O output;
            StackState returnState;
            if (state.isInit() && !Objects.equals(this.initialCall, input)) {
                return this.sink();
            }
            MealyMachine<S, I, T, O> model = this.procedures.get(input);
            if (model == null) {
                return this.sink();
            }
            Object next = model.getInitialState();
            if (next == null) {
                return this.sink();
            }
            if (state.isInit()) {
                returnState = StackState.term();
                output = this.initialOutput;
            } else {
                MealyMachine p = state.getProcedure();
                Object t = p.getTransition(state.getCurrentState(), input);
                if (t == null || this.isErrorOutput(p.getTransitionOutput(t))) {
                    return this.sink();
                }
                returnState = state.updateState(p.getSuccessor(t));
                output = p.getTransitionOutput(t);
            }
            return new MealyTransition(returnState.push(model, next), output);
        }
        if (this.alphabet.isReturnSymbol(input)) {
            if (state.isInit()) {
                return this.sink();
            }
            MealyMachine model = state.getProcedure();
            Object t = model.getTransition(state.getCurrentState(), input);
            if (t == null || this.isErrorOutput(model.getTransitionOutput(t))) {
                return this.sink();
            }
            return new MealyTransition(state.pop(), model.getTransitionOutput(t));
        }
        return this.sink();
    }

    @Override
    public StackState<S, I, MealyMachine<S, I, T, O>> getInitialState() {
        return StackState.init();
    }

    @Override
    public @Nullable I getInitialProcedure() {
        return this.initialCall;
    }

    @Override
    public ProceduralInputAlphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    @Override
    public O getErrorOutput() {
        return this.errorOutput;
    }

    @Override
    public Map<I, MealyMachine<?, I, ?, O>> getProcedures() {
        return Collections.unmodifiableMap(this.procedures);
    }

    @Override
    public O getTransitionOutput(MealyTransition<StackState<S, I, MealyMachine<S, I, T, O>>, O> transition) {
        return transition.getOutput();
    }

    @Override
    public StackState<S, I, MealyMachine<S, I, T, O>> getSuccessor(MealyTransition<StackState<S, I, MealyMachine<S, I, T, O>>, O> transition) {
        return transition.getSuccessor();
    }

    private MealyTransition<StackState<S, I, MealyMachine<S, I, T, O>>, O> sink() {
        return new MealyTransition(StackState.sink(), this.errorOutput);
    }
}

