/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.smartcollection;

import java.util.Arrays;
import java.util.List;
import java.util.PrimitiveIterator;

public interface IntSeq
extends Iterable<Integer> {
    public int size();

    public int get(int var1);

    default public PrimitiveIterator.OfInt iterator() {
        return new PrimitiveIterator.OfInt(){
            int curr = 0;

            @Override
            public int nextInt() {
                return IntSeq.this.get(this.curr++);
            }

            @Override
            public boolean hasNext() {
                return this.curr < IntSeq.this.size();
            }
        };
    }

    public static IntSeq of(final int ... ints) {
        return new IntSeq(){

            @Override
            public int size() {
                return ints.length;
            }

            @Override
            public int get(int index) {
                return ints[index];
            }

            public String toString() {
                return Arrays.toString(ints);
            }
        };
    }

    public static IntSeq of(final List<Integer> ints) {
        return new IntSeq(){

            @Override
            public int size() {
                return ints.size();
            }

            @Override
            public int get(int index) {
                return (Integer)ints.get(index);
            }

            public String toString() {
                return ints.toString();
            }
        };
    }
}

