/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.util.setting;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Properties;
import java.util.ServiceLoader;

public interface SettingsSource {
    public static <S extends SettingsSource> Properties readSettings(Class<S> clazz) {
        Properties p = new Properties();
        SettingsSource.readSettings(clazz, p);
        return p;
    }

    public static <S extends SettingsSource> void readSettings(Class<S> clazz, Properties p) {
        ServiceLoader<S> loader = ServiceLoader.load(clazz);
        ArrayList<SettingsSource> sources = new ArrayList<SettingsSource>();
        Iterators.addAll(sources, loader.iterator());
        sources.sort(Comparator.comparingInt(SettingsSource::getPriority));
        for (SettingsSource source : sources) {
            source.loadSettings(p);
        }
    }

    public void loadSettings(Properties var1);

    default public int getPriority() {
        return 0;
    }
}

