/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graph.visualization;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import net.automatalib.graph.ProceduralModalProcessGraph;
import net.automatalib.ts.modal.transition.ProceduralModalEdgeProperty;
import net.automatalib.visualization.DefaultVisualizationHelper;

public class PMPGVisualizationHelper<N, E, AP>
extends DefaultVisualizationHelper<N, E> {
    private final ProceduralModalProcessGraph<N, ?, E, AP, ?> pmpg;

    public PMPGVisualizationHelper(ProceduralModalProcessGraph<N, ?, E, AP, ?> pmpg) {
        this.pmpg = pmpg;
    }

    @Override
    protected Collection<N> initialNodes() {
        Object initialNode = this.pmpg.getInitialNode();
        if (initialNode == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(initialNode);
    }

    @Override
    public boolean getNodeProperties(N node, Map<String, String> properties) {
        super.getNodeProperties(node, properties);
        Set aps = (Set)this.pmpg.getNodeProperty(node);
        if (aps.isEmpty()) {
            properties.put("label", "");
        } else {
            properties.put("label", aps.toString());
        }
        if (Objects.equals(this.pmpg.getInitialNode(), node)) {
            properties.put("shape", "octagon");
        } else if (Objects.equals(this.pmpg.getFinalNode(), node)) {
            properties.put("shape", "box");
        } else {
            properties.put("shape", "circle");
        }
        return true;
    }

    @Override
    public boolean getEdgeProperties(N src, E edge, N tgt, Map<String, String> properties) {
        super.getEdgeProperties(src, edge, tgt, properties);
        ProceduralModalEdgeProperty prop = (ProceduralModalEdgeProperty)this.pmpg.getEdgeProperty(edge);
        StringJoiner styleJoiner = new StringJoiner(",");
        if (prop.isMayOnly()) {
            styleJoiner.add("dashed");
        }
        if (prop.isProcess()) {
            styleJoiner.add("bold");
        }
        properties.put("label", String.valueOf(this.pmpg.getEdgeLabel(edge)));
        properties.put("style", styleJoiner.toString());
        return true;
    }
}

