/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.m3c.formula;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.automatalib.common.util.collection.BitSetIterator;
import net.automatalib.modelchecker.m3c.formula.AbstractBinaryFormulaNode;
import net.automatalib.modelchecker.m3c.formula.AbstractUnaryFormulaNode;
import net.automatalib.modelchecker.m3c.formula.EquationalBlock;
import net.automatalib.modelchecker.m3c.formula.FormulaNode;
import net.automatalib.modelchecker.m3c.formula.modalmu.AbstractFixedPointFormulaNode;
import net.automatalib.modelchecker.m3c.formula.modalmu.GfpNode;
import net.automatalib.modelchecker.m3c.formula.modalmu.LfpNode;
import net.automatalib.modelchecker.m3c.formula.modalmu.VariableNode;

public class DependencyGraph<L, AP> {
    private final List<FormulaNode<L, AP>> formulaNodes = new ArrayList<FormulaNode<L, AP>>();
    private final List<EquationalBlock<L, AP>> blocks = new ArrayList<EquationalBlock<L, AP>>();
    private final Map<String, FormulaNode<L, AP>> fixedPointVarMap = new HashMap<String, FormulaNode<L, AP>>();
    private final FormulaNode<L, AP> ast;
    private final int numVars;

    public DependencyGraph(FormulaNode<L, AP> root) {
        this.ast = root.toNNF();
        this.numVars = this.setVarNumbers(this.ast, 0);
        this.createEquationalBlocks(this.ast);
    }

    private void sortBlocks() {
        for (EquationalBlock<L, AP> block : this.blocks) {
            Collections.reverse(block.getNodes());
        }
    }

    private void createEquationalBlocks(FormulaNode<L, AP> root) {
        boolean isMax = !(root instanceof LfpNode);
        EquationalBlock block = new EquationalBlock(isMax);
        this.blocks.add(block);
        this.createEquationalBlocks(root, 0);
        this.sortBlocks();
    }

    private void createEquationalBlocks(FormulaNode<L, AP> node, int blockNumber) {
        EquationalBlock<L, AP> currentBlock = this.blocks.get(blockNumber);
        boolean isMax = currentBlock.isMaxBlock();
        int newBlockNumber = blockNumber;
        if (node instanceof GfpNode && !isMax) {
            newBlockNumber = this.blocks.size();
            currentBlock = new EquationalBlock(true);
            this.blocks.add(currentBlock);
        } else if (node instanceof LfpNode && isMax) {
            newBlockNumber = this.blocks.size();
            currentBlock = new EquationalBlock(false);
            this.blocks.add(currentBlock);
        }
        if (!(node instanceof AbstractFixedPointFormulaNode) && !(node instanceof VariableNode)) {
            currentBlock.addNode(node);
        }
        if (node instanceof AbstractUnaryFormulaNode) {
            AbstractUnaryFormulaNode unaryNode = (AbstractUnaryFormulaNode)node;
            this.createEquationalBlocks(unaryNode.getChild(), newBlockNumber);
        } else if (node instanceof AbstractBinaryFormulaNode) {
            AbstractBinaryFormulaNode binaryNode = (AbstractBinaryFormulaNode)node;
            this.createEquationalBlocks(binaryNode.getLeftChild(), newBlockNumber);
            this.createEquationalBlocks(binaryNode.getRightChild(), newBlockNumber);
        }
    }

    private int setVarNumbers(FormulaNode<L, AP> node, int varNumber) {
        if (node instanceof AbstractFixedPointFormulaNode) {
            this.fixedPointVarMap.put(((AbstractFixedPointFormulaNode)node).getVariable(), node);
        }
        if (node instanceof VariableNode) {
            String refVariable = ((VariableNode)node).getVariable();
            FormulaNode<L, AP> refNode = this.fixedPointVarMap.get(refVariable);
            assert (refNode != null) : "Cannot reference unknown variable";
            node.setVarNumber(refNode.getVarNumber());
        } else {
            node.setVarNumber(varNumber);
        }
        int newVarNumber = varNumber;
        if (!(node instanceof AbstractFixedPointFormulaNode) && !(node instanceof VariableNode)) {
            ++newVarNumber;
            this.formulaNodes.add(node);
        }
        if (node instanceof AbstractUnaryFormulaNode) {
            AbstractUnaryFormulaNode unaryNode = (AbstractUnaryFormulaNode)node;
            newVarNumber = this.setVarNumbers(unaryNode.getChild(), newVarNumber);
        } else if (node instanceof AbstractBinaryFormulaNode) {
            AbstractBinaryFormulaNode binaryNode = (AbstractBinaryFormulaNode)node;
            newVarNumber = this.setVarNumbers(binaryNode.getLeftChild(), newVarNumber);
            newVarNumber = this.setVarNumbers(binaryNode.getRightChild(), newVarNumber);
        }
        return newVarNumber;
    }

    public EquationalBlock<L, AP> getBlock(int index) {
        return this.blocks.get(index);
    }

    public int getNumVariables() {
        return this.numVars;
    }

    public List<FormulaNode<L, AP>> getFormulaNodes() {
        return this.formulaNodes;
    }

    public List<EquationalBlock<L, AP>> getBlocks() {
        return this.blocks;
    }

    public FormulaNode<L, AP> getAST() {
        return this.ast;
    }

    public boolean[] toBoolArray(BitSet satisfiedVars) {
        boolean[] arr = new boolean[this.getNumVariables()];
        BitSetIterator iter = new BitSetIterator(satisfiedVars);
        while (iter.hasNext()) {
            arr[iter.nextInt()] = true;
        }
        return arr;
    }
}

