/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.m3c.solver;

import java.util.ArrayList;
import java.util.Collections;
import net.automatalib.graph.CompactGraph;
import net.automatalib.modelchecker.m3c.solver.WitnessTreeState;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class WitnessTree<L, AP>
extends CompactGraph<WitnessTreeState<?, L, ?, AP>, String> {
    private @MonotonicNonNull Word<L> result;

    public Word<L> getWitness() {
        assert (this.result != null);
        return this.result;
    }

    void computePath(int finishingNode) {
        int currentNode = finishingNode;
        ArrayList tmpPath = new ArrayList();
        while (currentNode >= 0) {
            WitnessTreeState prop = (WitnessTreeState)super.getNodeProperty(currentNode);
            assert (prop != null);
            Object label = prop.edgeLabel;
            prop.isPartOfResult = true;
            if (label != null) {
                tmpPath.add(label);
            }
            currentNode = prop.parentId;
        }
        Collections.reverse(tmpPath);
        this.result = Word.fromList(tmpPath);
    }
}

