/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.m3c.visualization;

import java.util.Map;
import net.automatalib.modelchecker.m3c.solver.WitnessTree;
import net.automatalib.modelchecker.m3c.solver.WitnessTreeState;
import net.automatalib.modelchecker.m3c.visualization.AbstractVisualizationHelper;

public class HTMLVisualizationHelper
extends AbstractVisualizationHelper {
    private final boolean shortDisplay;

    public HTMLVisualizationHelper(WitnessTree<?, ?> resultTree) {
        this(resultTree, false);
    }

    public HTMLVisualizationHelper(WitnessTree<?, ?> resultTree, boolean shortDisplay) {
        super(resultTree);
        this.shortDisplay = shortDisplay;
    }

    @Override
    public boolean getNodeProperties(Integer node, Map<String, String> properties) {
        super.getNodeProperties(node, properties);
        WitnessTreeState prop = (WitnessTreeState)this.resultTree.getNodeProperty(node);
        String label = "<HTML><TABLE BORDER=\"0px\"><TR><TD>State:</TD><TD>" + prop.state + "</TD> </TR><TR><TD>Context:</TD><TD>" + prop.context + "</TD></TR><TR><TD>Procedure:</TD><TD>" + prop.procedure + "</TD> </TR><TR><TD>ReturnAddress:</TD><TD>" + (prop.stack != null ? prop.stack.state : null) + "</TD></TR><TR><TD>Formula:</TD><TD>" + this.renderFormula(node) + "</TD></TR></TABLE>";
        properties.put("label", label);
        return true;
    }

    private String renderFormula(Integer node) {
        WitnessTreeState prop = (WitnessTreeState)this.resultTree.getNodeProperty(node);
        if (this.shortDisplay) {
            return Integer.toString(prop.subformula.getVarNumber());
        }
        String formula = prop.subformula.toString();
        return formula.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }
}

