/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.saf;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.automaton.AutomatonCreator;
import net.automatalib.automaton.MutableAutomaton;
import net.automatalib.automaton.fsa.CompactDFA;
import net.automatalib.automaton.fsa.CompactNFA;
import net.automatalib.common.util.IOUtil;
import net.automatalib.serialization.FormatException;
import net.automatalib.serialization.saf.AcceptanceDecoder;
import net.automatalib.serialization.saf.AutomatonType;
import net.automatalib.serialization.saf.BlockPropertyDecoder;
import net.automatalib.serialization.saf.SinglePropertyDecoder;

class SAFInput {
    private static final AutomatonType[] TYPES = AutomatonType.values();
    private final DataInput in;

    SAFInput(byte[] data) {
        this(new ByteArrayInputStream(data));
    }

    SAFInput(InputStream is) {
        this(new DataInputStream(is));
    }

    SAFInput(DataInput in) {
        this.in = in;
    }

    SAFInput(File file) throws IOException {
        this(IOUtil.asBufferedInputStream(file));
    }

    public <I> CompactDFA<I> readDFA(Alphabet<I> alphabet) throws IOException {
        return (CompactDFA)this.readAutomaton(AutomatonType.DFA, alphabet, new CompactDFA.Creator(), new AcceptanceDecoder(), SinglePropertyDecoder.nullDecoder());
    }

    public <I, SP, TP, A extends MutableAutomaton<?, I, ?, SP, TP>> A readAutomaton(AutomatonType expectedType, Alphabet<I> alphabet, AutomatonCreator<? extends A, I> creator, BlockPropertyDecoder<? extends SP> spDecoder, SinglePropertyDecoder<? extends TP> tpDecoder) throws IOException {
        AutomatonType type = this.readHeader();
        if (type != expectedType) {
            throw new FormatException();
        }
        int alphabetSize = this.in.readInt();
        if (alphabetSize != alphabet.size()) {
            throw new FormatException();
        }
        return this.readAutomatonBody(alphabet, type.isDeterministic(), creator, spDecoder, tpDecoder);
    }

    private AutomatonType readHeader() throws IOException {
        int headerSize = 4;
        byte[] header = new byte[4];
        this.in.readFully(header);
        if (header[0] != 83 || header[1] != 65 || header[2] != 70) {
            throw new FormatException();
        }
        byte type = header[3];
        if (type < 0 || type >= TYPES.length) {
            throw new FormatException();
        }
        return TYPES[type];
    }

    private <I, SP, TP, A extends MutableAutomaton<?, I, ?, SP, TP>> A readAutomatonBody(Alphabet<I> alphabet, boolean deterministic, AutomatonCreator<? extends A, I> creator, BlockPropertyDecoder<? extends SP> spDecoder, SinglePropertyDecoder<? extends TP> tpDecoder) throws IOException {
        int numStates = this.in.readInt();
        MutableAutomaton result = (MutableAutomaton)creator.createAutomaton(alphabet, numStates);
        if (deterministic) {
            this.decodeBodyDet(result, alphabet, numStates, spDecoder, tpDecoder);
        } else {
            this.decodeBodyNondet(result, alphabet, numStates, spDecoder, tpDecoder);
        }
        return (A)result;
    }

    private <S, I, SP, TP> List<S> decodeBodyDet(MutableAutomaton<S, I, ?, SP, TP> result, Alphabet<I> alphabet, int numStates, BlockPropertyDecoder<? extends SP> spDecoder, SinglePropertyDecoder<? extends TP> tpDecoder) throws IOException {
        List<S> stateList = this.decodeStatesDet(result, numStates, spDecoder);
        this.decodeTransitionsDet(result, stateList, alphabet, tpDecoder);
        return stateList;
    }

    private <S, I, SP, TP> List<S> decodeBodyNondet(MutableAutomaton<S, I, ?, SP, TP> result, Alphabet<I> alphabet, int numStates, BlockPropertyDecoder<? extends SP> spDecoder, SinglePropertyDecoder<? extends TP> tpDecoder) throws IOException {
        List<S> stateList = this.decodeStatesNondet(result, numStates, spDecoder);
        this.decodeTransitionsNondet(result, stateList, alphabet, tpDecoder);
        return stateList;
    }

    private <S, SP> List<S> decodeStatesDet(MutableAutomaton<S, ?, ?, SP, ?> result, int numStates, BlockPropertyDecoder<? extends SP> decoder) throws IOException {
        int initStateId = this.in.readInt();
        List<S> stateList = this.decodeStateProperties(result, numStates, decoder);
        S initState = stateList.get(initStateId);
        result.setInitial(initState, true);
        return stateList;
    }

    private <S, I, TP> void decodeTransitionsDet(MutableAutomaton<S, I, ?, ?, TP> result, List<S> stateList, Alphabet<I> alphabet, SinglePropertyDecoder<? extends TP> tpDecoder) throws IOException {
        int numStates = stateList.size();
        assert (result.size() == numStates);
        int numInputs = alphabet.size();
        for (S state : stateList) {
            for (int j = 0; j < numInputs; ++j) {
                int tgt = this.in.readInt();
                if (tgt == -1) continue;
                I sym = alphabet.getSymbol(j);
                S tgtState = stateList.get(tgt);
                TP prop = tpDecoder.readProperty(this.in);
                result.addTransition(state, sym, tgtState, prop);
            }
        }
    }

    private <S, SP> List<S> decodeStatesNondet(MutableAutomaton<S, ?, ?, SP, ?> result, int numStates, BlockPropertyDecoder<? extends SP> decoder) throws IOException {
        int[] initStates = SAFInput.readInts(this.in);
        List<S> stateList = this.decodeStateProperties(result, numStates, decoder);
        for (int initId : initStates) {
            S initState = stateList.get(initId);
            result.setInitial(initState, true);
        }
        return stateList;
    }

    private <S, I, TP> void decodeTransitionsNondet(MutableAutomaton<S, I, ?, ?, TP> result, List<S> stateList, Alphabet<I> alphabet, SinglePropertyDecoder<? extends TP> tpDecoder) throws IOException {
        int numStates = stateList.size();
        assert (result.size() == numStates);
        int numInputs = alphabet.size();
        for (S state : stateList) {
            for (int j = 0; j < numInputs; ++j) {
                int numTgts = this.in.readInt();
                I sym = alphabet.getSymbol(j);
                for (int k = 0; k < numTgts; ++k) {
                    int tgt = this.in.readInt();
                    TP prop = tpDecoder.readProperty(this.in);
                    S tgtState = stateList.get(tgt);
                    result.addTransition(state, sym, tgtState, prop);
                }
            }
        }
    }

    private <S, SP> List<S> decodeStateProperties(MutableAutomaton<S, ?, ?, SP, ?> result, int numStates, BlockPropertyDecoder<? extends SP> decoder) throws IOException {
        ArrayList<S> stateList = new ArrayList<S>(numStates);
        decoder.start(this.in);
        for (int i = 0; i < numStates; ++i) {
            SP prop = decoder.readProperty(this.in);
            S state = result.addState(prop);
            stateList.add(state);
        }
        decoder.finish(this.in);
        return stateList;
    }

    private static int[] readInts(DataInput in) throws IOException {
        int n = in.readInt();
        int[] result = new int[n];
        for (int i = 0; i < n; ++i) {
            result[i] = in.readInt();
        }
        return result;
    }

    public CompactDFA<Integer> readNativeDFA() throws IOException {
        return (CompactDFA)this.readNativeAutomaton(AutomatonType.DFA, new CompactDFA.Creator<Integer>(), new AcceptanceDecoder(), SinglePropertyDecoder.nullDecoder());
    }

    public <SP, TP, A extends MutableAutomaton<?, Integer, ?, SP, TP>> A readNativeAutomaton(AutomatonType expectedType, AutomatonCreator<? extends A, Integer> creator, BlockPropertyDecoder<? extends SP> spDecoder, SinglePropertyDecoder<? extends TP> tpDecoder) throws IOException {
        AutomatonType type = this.readHeader();
        if (type != expectedType) {
            throw new FormatException();
        }
        int alphabetSize = this.in.readInt();
        if (alphabetSize <= 0) {
            throw new FormatException();
        }
        Alphabet<Integer> alphabet = Alphabets.integers(0, alphabetSize - 1);
        return this.readAutomatonBody(alphabet, type.isDeterministic(), creator, spDecoder, tpDecoder);
    }

    public <I> CompactNFA<I> readNFA(Alphabet<I> alphabet) throws IOException {
        return (CompactNFA)this.readAutomaton(AutomatonType.NFA, alphabet, new CompactNFA.Creator(), new AcceptanceDecoder(), SinglePropertyDecoder.nullDecoder());
    }

    public CompactNFA<Integer> readNativeNFA() throws IOException {
        return (CompactNFA)this.readNativeAutomaton(AutomatonType.NFA, new CompactNFA.Creator<Integer>(), new AcceptanceDecoder(), SinglePropertyDecoder.nullDecoder());
    }
}

