/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts.modal;

import net.automatalib.alphabet.Alphabet;
import net.automatalib.ts.modal.AbstractCompactMTS;
import net.automatalib.ts.modal.MTSTransition;
import net.automatalib.ts.modal.transition.ModalEdgeProperty;
import net.automatalib.ts.modal.transition.ModalEdgePropertyImpl;
import net.automatalib.ts.modal.transition.MutableModalEdgeProperty;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CompactMTS<I>
extends AbstractCompactMTS<I, MTSTransition<MutableModalEdgeProperty>, MutableModalEdgeProperty> {
    public CompactMTS(Alphabet<I> alphabet) {
        super(alphabet);
    }

    public CompactMTS(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        super(alphabet, stateCapacity, resizeFactor);
    }

    @Override
    protected MutableModalEdgeProperty getDefaultTransitionProperty() {
        return this.buildModalProperty(ModalEdgeProperty.ModalType.MUST);
    }

    @Override
    protected MutableModalEdgeProperty buildModalProperty(ModalEdgeProperty.ModalType type) {
        return new ModalEdgePropertyImpl(type);
    }

    @Override
    public void setTransitionProperty(MTSTransition<MutableModalEdgeProperty> transition, MutableModalEdgeProperty property) {
        transition.setProperty(property);
    }

    @Override
    public MTSTransition<MutableModalEdgeProperty> createTransition(Integer successor) {
        return this.createTransition(successor, null);
    }

    @Override
    public MTSTransition<MutableModalEdgeProperty> createTransition(Integer successor, @Nullable MutableModalEdgeProperty properties) {
        return new MTSTransition<MutableModalEdgeProperty>(successor, properties == null ? this.getDefaultTransitionProperty() : properties);
    }

    @Override
    public Integer getSuccessor(MTSTransition<MutableModalEdgeProperty> transition) {
        return transition.getTarget();
    }

    @Override
    public MutableModalEdgeProperty getTransitionProperty(MTSTransition<MutableModalEdgeProperty> transition) {
        return transition.getProperty();
    }
}

