/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.builder;

import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.CompactTransition;
import net.automatalib.automaton.MutableAutomaton;
import net.automatalib.automaton.fsa.CompactDFA;
import net.automatalib.automaton.fsa.CompactNFA;
import net.automatalib.automaton.fsa.MutableDFA;
import net.automatalib.automaton.transducer.CompactMealy;
import net.automatalib.automaton.transducer.CompactMoore;
import net.automatalib.automaton.transducer.CompactSST;
import net.automatalib.automaton.transducer.MutableMealyMachine;
import net.automatalib.automaton.transducer.MutableMooreMachine;
import net.automatalib.automaton.transducer.MutableSubsequentialTransducer;
import net.automatalib.util.automaton.builder.AutomatonBuilder;
import net.automatalib.util.automaton.builder.DFABuilder;
import net.automatalib.util.automaton.builder.FSABuilder;
import net.automatalib.util.automaton.builder.MealyBuilder;
import net.automatalib.util.automaton.builder.MooreBuilder;
import net.automatalib.word.Word;

public final class AutomatonBuilders {
    private AutomatonBuilders() {
    }

    public static <S, I, T, SP, TP, A extends MutableAutomaton<S, ? super I, T, ? super SP, ? super TP>> AutomatonBuilder<S, I, T, SP, TP, A> forAutomaton(A automaton) {
        return new AutomatonBuilder(automaton);
    }

    public static <I> DFABuilder<Integer, I, CompactDFA<I>> newDFA(Alphabet<I> alphabet) {
        return AutomatonBuilders.forDFA(new CompactDFA<I>(alphabet));
    }

    public static <S, I, A extends MutableDFA<S, ? super I>> DFABuilder<S, I, A> forDFA(A dfa) {
        return new DFABuilder(dfa);
    }

    public static <I> FSABuilder<Integer, I, CompactNFA<I>> newNFA(Alphabet<I> alphabet) {
        return new FSABuilder(new CompactNFA<I>(alphabet));
    }

    public static <I, O> MealyBuilder<Integer, I, CompactTransition<O>, O, CompactMealy<I, O>> newMealy(Alphabet<I> alphabet) {
        return AutomatonBuilders.forMealy(new CompactMealy(alphabet));
    }

    public static <S, I, T, O, A extends MutableMealyMachine<S, ? super I, T, ? super O>> MealyBuilder<S, I, T, O, A> forMealy(A mealy) {
        return new MealyBuilder(mealy);
    }

    public static <I, O> MooreBuilder<Integer, I, Integer, O, CompactMoore<I, O>> newMoore(Alphabet<I> alphabet) {
        return AutomatonBuilders.forMoore(new CompactMoore(alphabet));
    }

    public static <S, I, T, O, A extends MutableMooreMachine<S, ? super I, T, ? super O>> MooreBuilder<S, I, T, O, A> forMoore(A moore) {
        return new MooreBuilder(moore);
    }

    public static <I, O> AutomatonBuilder<Integer, I, CompactTransition<Word<O>>, Word<O>, Word<O>, CompactSST<I, O>> newSST(Alphabet<I> alphabet) {
        return AutomatonBuilders.forSST(new CompactSST(alphabet));
    }

    public static <S, I, T, O, A extends MutableSubsequentialTransducer<S, ? super I, T, ? super O>> AutomatonBuilder<S, I, T, Word<O>, Word<O>, A> forSST(A sst) {
        return new AutomatonBuilder(sst);
    }
}

