/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.procedural;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.alphabet.VPAlphabet;
import net.automatalib.automaton.fsa.CompactDFA;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.procedural.SPA;
import net.automatalib.automaton.vpa.DefaultNSEVPA;
import net.automatalib.automaton.vpa.Location;
import net.automatalib.automaton.vpa.SEVPA;
import net.automatalib.common.util.Pair;
import net.automatalib.util.automaton.Automata;
import net.automatalib.util.automaton.copy.AutomatonCopyMethod;
import net.automatalib.util.automaton.copy.AutomatonLowLevelCopy;
import net.automatalib.util.automaton.procedural.ATRSequences;
import net.automatalib.util.automaton.procedural.OneSEVPAConverter;
import net.automatalib.util.automaton.procedural.SPAs;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

final class NSEVPAConverter {
    private NSEVPAConverter() {
    }

    public static <I> SEVPA<?, I> convert(SPA<?, I> spa) {
        Map<@Nullable I, List<Pair<Word<I>, Word<I>>>> contextPairs = NSEVPAConverter.computeContextPairs(spa);
        return NSEVPAConverter.constructNSEVPA(spa, contextPairs);
    }

    private static <I> Map<@Nullable I, List<Pair<Word<I>, Word<I>>>> computeContextPairs(SPA<?, I> spa) {
        ATRSequences<I> atrSequences = SPAs.computeATRSequences(spa);
        Alphabet inputAlphabet = spa.getInputAlphabet();
        HashMap<@Nullable I, List<Pair<Word<I>, Word<I>>>> contextPairs = Maps.newHashMapWithExpectedSize(inputAlphabet.getNumCalls() + 1);
        contextPairs.put(null, Collections.singletonList(Pair.of(Word.epsilon(), Word.epsilon())));
        for (Map.Entry e : spa.getProcedures().entrySet()) {
            contextPairs.put(e.getKey(), NSEVPAConverter.computeContextPair(e.getKey(), (DFA)e.getValue(), inputAlphabet, atrSequences));
        }
        return contextPairs;
    }

    private static <I> List<Pair<Word<I>, Word<I>>> computeContextPair(I procedure, DFA<?, I> dfa, ProceduralInputAlphabet<I> alphabet, ATRSequences<I> atr) {
        DFA<?, I> actualDFA;
        Alphabet<I> pAlphabet = alphabet.getProceduralAlphabet();
        if (NSEVPAConverter.hasSink(dfa, pAlphabet)) {
            actualDFA = dfa;
        } else {
            CompactDFA compactDFA = new CompactDFA(pAlphabet);
            AutomatonLowLevelCopy.copy(AutomatonCopyMethod.BFS, dfa, pAlphabet, compactDFA);
            Integer sink = compactDFA.addState(false);
            for (Object i : pAlphabet) {
                compactDFA.setTransition(sink, i, sink);
            }
            actualDFA = compactDFA;
        }
        List<Word<I>> cs = Automata.characterizingSet(actualDFA, pAlphabet);
        ArrayList<Pair<Word<I>, Word<I>>> result = new ArrayList<Pair<Word<I>, Word<I>>>(cs.size());
        Word as = atr.accessSequences.get(procedure);
        Word rs = atr.returnSequences.get(procedure);
        for (Word<I> w : cs) {
            result.add(Pair.of(as, alphabet.expand(w, atr.terminatingSequences::get).concat(rs)));
        }
        return result;
    }

    private static <I> SEVPA<?, I> constructNSEVPA(SPA<?, I> spa, Map<@Nullable I, List<Pair<Word<I>, Word<I>>>> contextPairs) {
        Alphabet alphabet = spa.getInputAlphabet();
        HashMap mainLocations = new HashMap();
        HashMap<BitSet, Location> mainSignatures = new HashMap<BitSet, Location>();
        DefaultNSEVPA<Object> vpa = new DefaultNSEVPA<Object>((VPAlphabet<Object>)alphabet);
        Location init = vpa.addInitialLocation(false);
        mainLocations.put(Word.epsilon(), init);
        mainSignatures.put(OneSEVPAConverter.computeSignature(spa, contextPairs.get(null), Word.epsilon()), init);
        ArrayList locationContexts = new ArrayList();
        locationContexts.add(new ModuleContext<Object>(null, Word.epsilon(), mainLocations, mainSignatures));
        for (Object i : alphabet.getCallAlphabet()) {
            HashMap moduleLocation = new HashMap();
            HashMap<BitSet, Location> moduleSignature = new HashMap<BitSet, Location>();
            Location entry = vpa.addModuleEntryLocation(i, false);
            moduleLocation.put(Word.epsilon(), entry);
            moduleSignature.put(OneSEVPAConverter.computeSignature(spa, contextPairs.get(i), Word.epsilon()), entry);
            locationContexts.add(new ModuleContext(i, Word.epsilon(), moduleLocation, moduleSignature));
        }
        int queuePtr = 0;
        while (queuePtr < locationContexts.size()) {
            ModuleContext context = (ModuleContext)locationContexts.get(queuePtr++);
            Object procedure = context.procedure;
            Word sp = context.sp;
            Map locationMap = context.locationMap;
            Map<BitSet, Location> signatureMap = context.signatureMap;
            Location loc = locationMap.get(sp);
            for (Object i : alphabet.getInternalAlphabet()) {
                Word lp = sp.append(i);
                BitSet sig = OneSEVPAConverter.computeSignature(spa, contextPairs.get(procedure), lp);
                Location succ = signatureMap.get(sig);
                if (succ == null) {
                    Location newLoc = procedure == null ? vpa.addLocation(sig.get(0)) : vpa.addLocation(procedure, false);
                    locationMap.put(lp, newLoc);
                    signatureMap.put(sig, newLoc);
                    locationContexts.add(new ModuleContext(procedure, lp, locationMap, signatureMap));
                    succ = newLoc;
                }
                vpa.setInternalSuccessor(loc, i, succ);
            }
            for (Object i : alphabet.getCallAlphabet()) {
                int stackSym = vpa.encodeStackSym(loc, i);
                for (int j = 0; j < queuePtr; ++j) {
                    ModuleContext otherContext = (ModuleContext)locationContexts.get(j);
                    Object otherProcedure = otherContext.procedure;
                    Word otherSp = otherContext.sp;
                    Map otherLocationMap = otherContext.locationMap;
                    Map<BitSet, Location> otherSignatureMap = otherContext.signatureMap;
                    Location otherLoc = otherLocationMap.get(otherSp);
                    Word lp1 = otherSp.append(i).concat(sp).append(alphabet.getReturnSymbol());
                    BitSet sig1 = OneSEVPAConverter.computeSignature(spa, contextPairs.get(otherProcedure), lp1);
                    Location succ1 = otherSignatureMap.get(sig1);
                    if (succ1 == null) {
                        Location newLoc = otherProcedure == null ? vpa.addLocation(sig1.get(0)) : vpa.addLocation(otherProcedure, false);
                        otherLocationMap.put(lp1, newLoc);
                        otherSignatureMap.put(sig1, newLoc);
                        locationContexts.add(new ModuleContext(otherProcedure, lp1, otherLocationMap, otherSignatureMap));
                        succ1 = newLoc;
                    }
                    vpa.setReturnSuccessor(loc, alphabet.getReturnSymbol(), vpa.encodeStackSym(otherLoc, i), succ1);
                    Word lp2 = sp.append(i).concat(otherSp).append(alphabet.getReturnSymbol());
                    BitSet sig2 = OneSEVPAConverter.computeSignature(spa, contextPairs.get(procedure), lp2);
                    Location succ2 = signatureMap.get(sig2);
                    if (succ2 == null) {
                        Location newLoc = procedure == null ? vpa.addLocation(sig2.get(0)) : vpa.addLocation(procedure, false);
                        locationMap.put(lp2, newLoc);
                        signatureMap.put(sig2, newLoc);
                        locationContexts.add(new ModuleContext(procedure, lp2, locationMap, signatureMap));
                        succ2 = newLoc;
                    }
                    vpa.setReturnSuccessor(otherLoc, alphabet.getReturnSymbol(), stackSym, succ2);
                }
            }
        }
        return vpa;
    }

    private static <S, I> boolean hasSink(DFA<S, I> dfa, Alphabet<I> alphabet) {
        for (Object s2 : dfa) {
            if (!NSEVPAConverter.isSink(dfa, alphabet, s2)) continue;
            return true;
        }
        return false;
    }

    private static <S, I> boolean isSink(DFA<S, I> dfa, Collection<? extends I> inputs, S state) {
        if (dfa.isAccepting(state)) {
            return false;
        }
        for (I i : inputs) {
            S succ = dfa.getSuccessor(state, i);
            if (Objects.equals(succ, state)) continue;
            return false;
        }
        return true;
    }

    private static class ModuleContext<I> {
        final @Nullable I procedure;
        final Word<I> sp;
        final Map<Word<I>, Location> locationMap;
        final Map<BitSet, Location> signatureMap;

        ModuleContext(@Nullable I procedure, Word<I> sp, Map<Word<I>, Location> locationMap, Map<BitSet, Location> signatureMap) {
            this.procedure = procedure;
            this.sp = sp;
            this.locationMap = locationMap;
            this.signatureMap = signatureMap;
        }
    }
}

