/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.procedural;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.alphabet.VPAlphabet;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.procedural.SPA;
import net.automatalib.automaton.vpa.DefaultOneSEVPA;
import net.automatalib.automaton.vpa.Location;
import net.automatalib.automaton.vpa.OneSEVPA;
import net.automatalib.common.util.Pair;
import net.automatalib.util.automaton.Automata;
import net.automatalib.util.automaton.procedural.ATRSequences;
import net.automatalib.util.automaton.procedural.SPAs;
import net.automatalib.word.Word;

final class OneSEVPAConverter {
    private OneSEVPAConverter() {
    }

    public static <I> OneSEVPA<?, I> convert(SPA<?, I> spa) {
        List<Pair<Word<I>, Word<I>>> contextPairs = OneSEVPAConverter.computeContextPairs(spa);
        return OneSEVPAConverter.constructOneSEVPA(spa, contextPairs);
    }

    private static <I> List<Pair<Word<I>, Word<I>>> computeContextPairs(SPA<?, I> spa) {
        ATRSequences<I> atrSequences = SPAs.computeATRSequences(spa);
        Alphabet inputAlphabet = spa.getInputAlphabet();
        ArrayList<Pair<Word<I>, Word<I>>> contextPairs = new ArrayList<Pair<Word<I>, Word<I>>>();
        contextPairs.add(Pair.of(Word.epsilon(), Word.epsilon()));
        for (Map.Entry e : spa.getProcedures().entrySet()) {
            contextPairs.addAll(OneSEVPAConverter.computeContextPair(e.getKey(), (DFA)e.getValue(), inputAlphabet, atrSequences));
        }
        return contextPairs;
    }

    private static <I> List<Pair<Word<I>, Word<I>>> computeContextPair(I procedure, DFA<?, I> dfa, ProceduralInputAlphabet<I> alphabet, ATRSequences<I> atr) {
        List<Word<I>> cs = Automata.characterizingSet(dfa, alphabet.getProceduralAlphabet());
        ArrayList<Pair<Word<I>, Word<I>>> result = new ArrayList<Pair<Word<I>, Word<I>>>(cs.size());
        Word as = atr.accessSequences.get(procedure);
        Word rs = atr.returnSequences.get(procedure);
        for (Word<I> w : cs) {
            result.add(Pair.of(as, alphabet.expand(w, atr.terminatingSequences::get).concat(rs)));
        }
        return result;
    }

    private static <I> OneSEVPA<?, I> constructOneSEVPA(SPA<?, I> spa, List<Pair<Word<I>, Word<I>>> contextPairs) {
        Alphabet alphabet = spa.getInputAlphabet();
        HashMap locationMap = new HashMap();
        HashMap<BitSet, Location> signatureMap = new HashMap<BitSet, Location>();
        DefaultOneSEVPA<Object> vpa = new DefaultOneSEVPA<Object>((VPAlphabet<Object>)alphabet);
        Location init = vpa.addInitialLocation(false);
        locationMap.put(Word.epsilon(), init);
        signatureMap.put(OneSEVPAConverter.computeSignature(spa, contextPairs, Word.epsilon()), init);
        ArrayList shortPrefixes = new ArrayList();
        shortPrefixes.add(Word.epsilon());
        int queuePtr = 0;
        while (queuePtr < shortPrefixes.size()) {
            Word sp = (Word)shortPrefixes.get(queuePtr++);
            Location loc = (Location)locationMap.get(sp);
            for (Object i : alphabet.getInternalAlphabet()) {
                Word lp = sp.append(i);
                BitSet sig = OneSEVPAConverter.computeSignature(spa, contextPairs, lp);
                Location succ = (Location)signatureMap.get(sig);
                if (succ == null) {
                    Location newLoc = vpa.addLocation(sig.get(0));
                    locationMap.put(lp, newLoc);
                    signatureMap.put(sig, newLoc);
                    shortPrefixes.add(lp);
                    succ = newLoc;
                }
                vpa.setInternalSuccessor(loc, i, succ);
            }
            for (Object i : alphabet.getCallAlphabet()) {
                int stackSym = vpa.encodeStackSym(loc, i);
                for (int j = 0; j < queuePtr; ++j) {
                    Word otherSp = (Word)shortPrefixes.get(j);
                    Location otherLoc = (Location)locationMap.get(otherSp);
                    Word lp1 = otherSp.append(i).concat(sp).append(alphabet.getReturnSymbol());
                    BitSet sig1 = OneSEVPAConverter.computeSignature(spa, contextPairs, lp1);
                    Location succ1 = (Location)signatureMap.get(sig1);
                    if (succ1 == null) {
                        Location newLoc = vpa.addLocation(sig1.get(0));
                        locationMap.put(lp1, newLoc);
                        signatureMap.put(sig1, newLoc);
                        shortPrefixes.add(lp1);
                        succ1 = newLoc;
                    }
                    vpa.setReturnSuccessor(loc, alphabet.getReturnSymbol(), vpa.encodeStackSym(otherLoc, i), succ1);
                    Word lp2 = sp.append(i).concat(otherSp).append(alphabet.getReturnSymbol());
                    BitSet sig2 = OneSEVPAConverter.computeSignature(spa, contextPairs, lp2);
                    Location succ2 = (Location)signatureMap.get(sig2);
                    if (succ2 == null) {
                        Location newLoc = vpa.addLocation(sig2.get(0));
                        locationMap.put(lp2, newLoc);
                        signatureMap.put(sig2, newLoc);
                        shortPrefixes.add(lp2);
                        succ2 = newLoc;
                    }
                    vpa.setReturnSuccessor(otherLoc, alphabet.getReturnSymbol(), stackSym, succ2);
                }
            }
        }
        return vpa;
    }

    static <I> BitSet computeSignature(SPA<?, I> spa, List<Pair<Word<I>, Word<I>>> contextPairs, Word<I> accessSequences) {
        BitSet sig = new BitSet(contextPairs.size());
        for (int i = 0; i < contextPairs.size(); ++i) {
            Pair<Word<I>, Word<I>> cp = contextPairs.get(i);
            sig.set(i, OneSEVPAConverter.accepts(spa, cp.getFirst(), accessSequences, cp.getSecond()));
        }
        return sig;
    }

    private static <S, I> boolean accepts(SPA<S, I> spa, Word<I> w1, Word<I> w2, Word<I> w3) {
        int i;
        Object iter = spa.getInitialState();
        for (i = 0; i < w1.length(); ++i) {
            iter = spa.getTransition(iter, w1.getSymbol(i));
        }
        for (i = 0; i < w2.length(); ++i) {
            iter = spa.getTransition(iter, w2.getSymbol(i));
        }
        for (i = 0; i < w3.length(); ++i) {
            iter = spa.getTransition(iter, w3.getSymbol(i));
        }
        return spa.isAccepting(iter);
    }
}

