/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.transducer;

import java.util.Collection;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.transducer.CompactMealy;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.automaton.transducer.MutableMealyMachine;
import net.automatalib.common.util.Pair;
import net.automatalib.ts.output.MealyTransitionSystem;
import net.automatalib.util.automaton.copy.AutomatonCopyMethod;
import net.automatalib.util.automaton.copy.AutomatonLowLevelCopy;
import net.automatalib.util.automaton.transducer.MutableMealyMachines;
import net.automatalib.util.ts.copy.TSCopy;
import net.automatalib.util.ts.transducer.Transducers;
import net.automatalib.util.ts.traversal.TSTraversalMethod;

public final class MealyMachines {
    private MealyMachines() {
    }

    public static <I, O1, O2> CompactMealy<I, Pair<O1, O2>> combine(MealyMachine<?, I, ?, O1> mealy1, MealyMachine<?, I, ?, O2> mealy2, Alphabet<I> inputAlphabet) {
        return MealyMachines.combine(mealy1, mealy2, inputAlphabet, new CompactMealy(inputAlphabet));
    }

    public static <I, O1, O2, A extends MutableMealyMachine<?, I, ?, Pair<O1, O2>>> A combine(MealyMachine<?, I, ?, O1> mealy1, MealyMachine<?, I, ?, O2> mealy2, Collection<? extends I> inputs, A out) {
        MealyTransitionSystem comb = Transducers.combine(mealy1, mealy2);
        TSCopy.copy(TSTraversalMethod.BREADTH_FIRST, comb, -1, inputs, out);
        return out;
    }

    public static <I, O> CompactMealy<I, O> complete(MealyMachine<?, I, ?, O> mealy, Alphabet<I> inputs, O undefinedOutput) {
        return MealyMachines.complete(mealy, inputs, undefinedOutput, new CompactMealy(inputs));
    }

    public static <S, I, T, O, A extends MutableMealyMachine<S, I, T, O>> A complete(MealyMachine<?, I, ?, O> mealy, Collection<? extends I> inputs, O undefinedOutput, A out) {
        AutomatonLowLevelCopy.copy(AutomatonCopyMethod.DFS, mealy, inputs, out);
        MutableMealyMachines.complete(out, inputs, undefinedOutput);
        return out;
    }
}

