/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.vpa;

import com.google.common.collect.Sets;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.automatalib.alphabet.VPAlphabet;
import net.automatalib.automaton.vpa.DefaultOneSEVPA;
import net.automatalib.automaton.vpa.OneSEVPA;
import net.automatalib.common.smartcollection.ArrayStorage;
import net.automatalib.common.util.Pair;
import net.automatalib.common.util.UnionFindRemSP;
import net.automatalib.util.automaton.vpa.ProductOneSEVPA;
import net.automatalib.util.automaton.vpa.SPAConverter;
import net.automatalib.util.automaton.vpa.SymbolMapper;
import net.automatalib.util.minimizer.OneSEVPAMinimizer;
import net.automatalib.util.ts.acceptor.AcceptanceCombiner;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;

public final class OneSEVPAs {
    private OneSEVPAs() {
    }

    public static <L1, L2, I> OneSEVPA<Pair<L1, L2>, I> and(OneSEVPA<L1, I> sevpa1, OneSEVPA<L2, I> sevpa2, VPAlphabet<I> alphabet) {
        return OneSEVPAs.combine(sevpa1, sevpa2, alphabet, AcceptanceCombiner.AND);
    }

    public static <L1, L2, I> OneSEVPA<Pair<L1, L2>, I> combine(OneSEVPA<L1, I> sevpa1, OneSEVPA<L2, I> sevpa2, VPAlphabet<I> alphabet, AcceptanceCombiner combiner) {
        return new ProductOneSEVPA<L1, L2, I>(alphabet, sevpa1, sevpa2, combiner);
    }

    public static <L1, L2, I> OneSEVPA<Pair<L1, L2>, I> or(OneSEVPA<L1, I> sevpa1, OneSEVPA<L2, I> sevpa2, VPAlphabet<I> alphabet) {
        return OneSEVPAs.combine(sevpa1, sevpa2, alphabet, AcceptanceCombiner.OR);
    }

    public static <L1, L2, I> OneSEVPA<Pair<L1, L2>, I> xor(OneSEVPA<L1, I> sevpa1, OneSEVPA<L2, I> sevpa2, VPAlphabet<I> alphabet) {
        return OneSEVPAs.combine(sevpa1, sevpa2, alphabet, AcceptanceCombiner.XOR);
    }

    public static <L1, L2, I> OneSEVPA<Pair<L1, L2>, I> equiv(OneSEVPA<L1, I> sevpa1, OneSEVPA<L2, I> sevpa2, VPAlphabet<I> alphabet) {
        return OneSEVPAs.combine(sevpa1, sevpa2, alphabet, AcceptanceCombiner.EQUIV);
    }

    public static <L1, L2, I> OneSEVPA<Pair<L1, L2>, I> impl(OneSEVPA<L1, I> sevpa1, OneSEVPA<L2, I> sevpa2, VPAlphabet<I> alphabet) {
        return OneSEVPAs.combine(sevpa1, sevpa2, alphabet, AcceptanceCombiner.IMPL);
    }

    public static <I> DefaultOneSEVPA<I> minimize(OneSEVPA<?, I> sevpa, VPAlphabet<I> alphabet) {
        return OneSEVPAMinimizer.minimize(sevpa, alphabet);
    }

    public static <L, I> @Nullable Word<I> computeAccessSequence(OneSEVPA<L, I> sevpa, VPAlphabet<I> alphabet, Predicate<? super L> predicate) {
        ReachResult<? super L, I> result = OneSEVPAs.computeAccessSequences(sevpa, alphabet, true, predicate);
        Object resultLoc = result.terminateLoc;
        if (resultLoc != null) {
            return result.accessSequences.get(sevpa.getLocationId(resultLoc));
        }
        return null;
    }

    public static <L, I> ArrayStorage<Word<I>> computeAccessSequences(OneSEVPA<L, I> sevpa, VPAlphabet<I> alphabet) {
        return OneSEVPAs.computeAccessSequences(sevpa, alphabet, (boolean)true, (Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$computeAccessSequences$0(java.lang.Object ), (Ljava/lang/Object;)Z)()).accessSequences;
    }

    private static <L, I> ReachResult<L, I> computeAccessSequences(OneSEVPA<L, I> sevpa, VPAlphabet<I> alphabet, boolean computeAs, Predicate<? super L> terminatePred) {
        ArrayStorage result = new ArrayStorage(sevpa.size());
        Object initLoc = sevpa.getInitialLocation();
        ArrayList<Object> reachable = new ArrayList<Object>();
        reachable.add(initLoc);
        result.set(sevpa.getLocationId(initLoc), Word.epsilon());
        if (terminatePred.test(initLoc)) {
            return new ReachResult(initLoc, reachable, result);
        }
        int queuePtr = 0;
        while (queuePtr < reachable.size()) {
            Object curr = reachable.get(queuePtr++);
            Word currAs = result.get(sevpa.getLocationId(curr));
            for (Object intSym : alphabet.getInternalAlphabet()) {
                int succIdx;
                Object succ = sevpa.getInternalSuccessor(curr, intSym);
                if (succ == null || result.get(succIdx = sevpa.getLocationId(succ)) != null) continue;
                Word succAs = computeAs ? currAs.append(intSym) : Word.epsilon();
                result.set(succIdx, succAs);
                if (terminatePred.test(succ)) {
                    return new ReachResult(succ, reachable, result);
                }
                reachable.add(succ);
            }
            for (Object callSym : alphabet.getCallAlphabet()) {
                for (Object returnSym : alphabet.getReturnAlphabet()) {
                    for (int i = 0; i < queuePtr; ++i) {
                        Word succAs;
                        Object src = reachable.get(i);
                        int stackSym = sevpa.encodeStackSym(src, callSym);
                        Object succ = sevpa.getReturnSuccessor(curr, returnSym, stackSym);
                        if (succ == null) continue;
                        int succIdx = sevpa.getLocationId(succ);
                        if (result.get(succIdx) == null) {
                            succAs = computeAs ? result.get(sevpa.getLocationId(src)).append(callSym).concat(currAs.append(returnSym)) : Word.epsilon();
                            result.set(succIdx, succAs);
                            if (terminatePred.test(succ)) {
                                return new ReachResult(succ, reachable, result);
                            }
                            reachable.add(succ);
                        }
                        if (src == curr || (succ = sevpa.getReturnSuccessor(src, returnSym, stackSym = sevpa.encodeStackSym(curr, callSym))) == null || result.get(succIdx = sevpa.getLocationId(succ)) != null) continue;
                        succAs = computeAs ? currAs.append(callSym).concat(result.get(sevpa.getLocationId(src)).append(returnSym)) : Word.epsilon();
                        result.set(succIdx, succAs);
                        if (terminatePred.test(succ)) {
                            return new ReachResult(succ, reachable, result);
                        }
                        reachable.add(succ);
                    }
                }
            }
        }
        return new ReachResult(null, reachable, result);
    }

    public static <I> boolean testEquivalence(OneSEVPA<?, I> sevpa1, OneSEVPA<?, I> sevpa2, VPAlphabet<I> alphabet) {
        return OneSEVPAs.findSeparatingWord(sevpa1, sevpa2, alphabet) == null;
    }

    public static <L, I> @Nullable Word<I> findAcceptedWord(OneSEVPA<L, I> sevpa, VPAlphabet<I> alphabet) {
        return OneSEVPAs.computeAccessSequence(sevpa, alphabet, sevpa::isAcceptingLocation);
    }

    public static <L, I> @Nullable Word<I> findRejectedWord(OneSEVPA<L, I> sevpa, VPAlphabet<I> alphabet) {
        return OneSEVPAs.computeAccessSequence(sevpa, alphabet, l -> !sevpa.isAcceptingLocation(l));
    }

    public static <L, I> List<L> findReachableLocations(OneSEVPA<L, I> sevpa, VPAlphabet<I> alphabet) {
        return OneSEVPAs.computeAccessSequences(sevpa, alphabet, (boolean)false, (Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$findReachableLocations$2(java.lang.Object ), (Ljava/lang/Object;)Z)()).reachableLocs;
    }

    public static <I> @Nullable Word<I> findSeparatingWord(OneSEVPA<?, I> sevpa1, OneSEVPA<?, I> sevpa2, VPAlphabet<I> alphabet) {
        OneSEVPA<Pair<?, ?>, I> prod = OneSEVPAs.xor(sevpa1, sevpa2, alphabet);
        return OneSEVPAs.findAcceptedWord(prod, alphabet);
    }

    public static <L, I> @Nullable Pair<Word<I>, Word<I>> findSeparatingWord(OneSEVPA<L, I> sevpa, L init1, L init2, VPAlphabet<I> alphabet) {
        Record current;
        if (sevpa.isAcceptingLocation(init1) != sevpa.isAcceptingLocation(init2)) {
            return Pair.of(Word.epsilon(), Word.epsilon());
        }
        ArrayStorage<Word<I>> as = OneSEVPAs.computeAccessSequences(sevpa, alphabet);
        UnionFindRemSP uf = new UnionFindRemSP(sevpa.size());
        uf.link(sevpa.getLocationId(init1), sevpa.getLocationId(init2));
        ArrayDeque queue = new ArrayDeque();
        queue.add(new Record(init1, init2));
        Pair lastPair = null;
        block0: while ((current = (Record)queue.poll()) != null) {
            Object l1 = current.l1;
            Object l2 = current.l2;
            for (Object i : alphabet.getInternalAlphabet()) {
                int r2;
                Pair pair = Pair.of(Word.epsilon(), Word.fromLetter(i));
                Object succ1 = sevpa.getInternalSuccessor(l1, i);
                Object succ2 = sevpa.getInternalSuccessor(l2, i);
                assert (succ1 != null && succ2 != null);
                if (sevpa.isAcceptingLocation(succ1) != sevpa.isAcceptingLocation(succ2)) {
                    lastPair = pair;
                    break block0;
                }
                int r1 = uf.find(sevpa.getLocationId(succ1));
                if (r1 == (r2 = uf.find(sevpa.getLocationId(succ2)))) continue;
                uf.link(r1, r2);
                queue.add(new Record(succ1, succ2, pair, current));
            }
            for (Object c : alphabet.getCallAlphabet()) {
                Word cWord = Word.fromLetter(c);
                for (Object r : alphabet.getReturnAlphabet()) {
                    Word rWord = Word.fromLetter(r);
                    for (Object l : sevpa.getLocations()) {
                        int r2;
                        int sym = sevpa.encodeStackSym(l, c);
                        Object rSucc1 = sevpa.getReturnSuccessor(l1, r, sym);
                        Object rSucc2 = sevpa.getReturnSuccessor(l2, r, sym);
                        assert (rSucc1 != null && rSucc2 != null);
                        Pair pair = Pair.of(Word.fromWords(as.get(sevpa.getLocationId(l)), cWord), rWord);
                        if (sevpa.isAcceptingLocation(rSucc1) != sevpa.isAcceptingLocation(rSucc2)) {
                            lastPair = pair;
                            break block0;
                        }
                        int r1 = uf.find(sevpa.getLocationId(rSucc1));
                        if (r1 == (r2 = uf.find(sevpa.getLocationId(rSucc2)))) continue;
                        uf.link(r1, r2);
                        queue.add(new Record(rSucc1, rSucc2, pair, current));
                    }
                    for (Object l : sevpa.getLocations()) {
                        int r2;
                        int sym1 = sevpa.encodeStackSym(l1, c);
                        int sym2 = sevpa.encodeStackSym(l2, c);
                        Object rSucc1 = sevpa.getReturnSuccessor(l, r, sym1);
                        Object rSucc2 = sevpa.getReturnSuccessor(l, r, sym2);
                        assert (rSucc1 != null && rSucc2 != null);
                        Pair pair = Pair.of(Word.epsilon(), Word.fromWords(cWord, as.get(sevpa.getLocationId(l)), rWord));
                        if (sevpa.isAcceptingLocation(rSucc1) != sevpa.isAcceptingLocation(rSucc2)) {
                            lastPair = pair;
                            break block0;
                        }
                        int r1 = uf.find(sevpa.getLocationId(rSucc1));
                        if (r1 == (r2 = uf.find(sevpa.getLocationId(rSucc2)))) continue;
                        uf.link(r1, r2);
                        queue.add(new Record(rSucc1, rSucc2, pair, current));
                    }
                }
            }
        }
        if (current == null) {
            return null;
        }
        ArrayDeque<Word> prefixBuilder = new ArrayDeque<Word>();
        ArrayDeque<Word> suffixBuilder = new ArrayDeque<Word>();
        prefixBuilder.add((Word)lastPair.getFirst());
        suffixBuilder.add((Word)lastPair.getSecond());
        while (current.reachedFrom != null) {
            Pair reachedBy = current.reachedBy;
            prefixBuilder.offerLast((Word)reachedBy.getFirst());
            suffixBuilder.offerFirst((Word)reachedBy.getSecond());
            current = current.reachedFrom;
        }
        return Pair.of(Word.fromWords(prefixBuilder), Word.fromWords(suffixBuilder));
    }

    public static <L, I> Collection<Pair<Word<I>, Word<I>>> findCharacterizingSet(OneSEVPA<L, I> sevpa, VPAlphabet<I> alphabet) {
        ArrayStorage<Word<I>> as = OneSEVPAs.computeAccessSequences(sevpa, alphabet);
        ArrayList acceptingLocations = new ArrayList(sevpa.size());
        ArrayList rejectionLocations = new ArrayList(sevpa.size());
        for (Object l : sevpa.getLocations()) {
            if (sevpa.isAcceptingLocation(l)) {
                acceptingLocations.add(l);
                continue;
            }
            rejectionLocations.add(l);
        }
        HashSet<Pair<Word<I>, Word<I>>> result = Sets.newHashSetWithExpectedSize(sevpa.size());
        result.add(Pair.of(Word.epsilon(), Word.epsilon()));
        ArrayDeque blockQueue = new ArrayDeque();
        blockQueue.add(acceptingLocations);
        blockQueue.add(rejectionLocations);
        while (!blockQueue.isEmpty()) {
            @NonNull List block = (List)blockQueue.poll();
            if (block.size() == 1) continue;
            Iterator blockIter = block.iterator();
            Object l1 = blockIter.next();
            Object l2 = blockIter.next();
            Pair<Word<I>, Word<I>> sepWord = OneSEVPAs.findSeparatingWord(sevpa, l1, l2, alphabet);
            assert (sepWord != null);
            result.add(sepWord);
            ArrayList acceptingBucket = new ArrayList(block.size());
            ArrayList rejectingBucket = new ArrayList(block.size());
            if (sevpa.accepts(Word.fromWords(sepWord.getFirst(), as.get(sevpa.getLocationId(l1)), sepWord.getSecond()))) {
                acceptingBucket.add(l1);
                rejectingBucket.add(l2);
            } else {
                acceptingBucket.add(l2);
                rejectingBucket.add(l1);
            }
            while (blockIter.hasNext()) {
                Object next = blockIter.next();
                if (sevpa.accepts(Word.fromWords(sepWord.getFirst(), as.get(sevpa.getLocationId(next)), sepWord.getSecond()))) {
                    acceptingBucket.add(next);
                    continue;
                }
                rejectingBucket.add(next);
            }
            blockQueue.add(acceptingBucket);
            blockQueue.add(rejectingBucket);
        }
        return result;
    }

    public static <AI, CI> SPAConverter.ConversionResult<AI, CI> toSPA(OneSEVPA<?, AI> sevpa, VPAlphabet<AI> alphabet, CI mainProcedure, SymbolMapper<AI, CI> symbolMapper, boolean minimize) {
        return SPAConverter.convert(sevpa, alphabet, mainProcedure, symbolMapper, minimize);
    }

    private static /* synthetic */ boolean lambda$findReachableLocations$2(Object l) {
        return false;
    }

    private static /* synthetic */ boolean lambda$computeAccessSequences$0(Object l) {
        return false;
    }

    private static final class Record<L, I> {
        private final L l1;
        private final L l2;
        private final @PolyNull Pair<Word<I>, Word<I>> reachedBy;
        private final @PolyNull Record<L, I> reachedFrom;

        Record(L l1, L l2) {
            this(l1, l2, null, null);
        }

        Record(L l1, L l2, @PolyNull Pair<Word<I>, Word<I>> reachedBy, @PolyNull Record<L, I> reachedFrom) {
            this.l1 = l1;
            this.l2 = l2;
            this.reachedBy = reachedBy;
            this.reachedFrom = reachedFrom;
        }
    }

    private static class ReachResult<L, I> {
        public final @Nullable L terminateLoc;
        public final List<L> reachableLocs;
        public final ArrayStorage<Word<I>> accessSequences;

        ReachResult(@Nullable L terminateLoc, List<L> reachableLocs, ArrayStorage<Word<I>> accessSequences) {
            this.terminateLoc = terminateLoc;
            this.reachableLocs = reachableLocs;
            this.accessSequences = accessSequences;
        }
    }
}

