/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graph;

import java.util.AbstractList;
import java.util.List;
import net.automatalib.graph.IndefiniteGraph;

public class Path<N, E>
extends AbstractList<E> {
    private final IndefiniteGraph<N, E> graph;
    private final N start;
    private final List<? extends E> edgeList;

    Path(IndefiniteGraph<N, E> graph, N start, List<? extends E> edgeList) {
        this.graph = graph;
        this.start = start;
        this.edgeList = edgeList;
    }

    @Override
    public E get(int index) {
        return this.edgeList.get(index);
    }

    @Override
    public int size() {
        return this.edgeList.size();
    }

    public List<N> getNodes() {
        return new NodeList();
    }

    private class NodeList
    extends AbstractList<N> {
        private NodeList() {
        }

        @Override
        public N get(int index) {
            if (index == 0) {
                return Path.this.start;
            }
            Object edge = Path.this.edgeList.get(index - 1);
            return Path.this.graph.getTarget(edge);
        }

        @Override
        public int size() {
            return Path.this.edgeList.size() + 1;
        }
    }
}

