/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graph.copy;

import java.util.ArrayList;
import net.automatalib.common.util.mapping.Mapping;
import net.automatalib.graph.Graph;
import net.automatalib.graph.MutableGraph;
import net.automatalib.util.graph.copy.AbstractGraphCopy;

final class PlainGraphCopy<N1, E1, N2, E2, NP2, EP2>
extends AbstractGraphCopy<N1, E1, N2, E2, NP2, EP2, Graph<N1, E1>> {
    PlainGraphCopy(Graph<N1, E1> inGraph, MutableGraph<N2, E2, NP2, EP2> outGraph, Mapping<? super N1, ? extends NP2> npMapping, Mapping<? super E1, ? extends EP2> epMapping) {
        super(inGraph, outGraph, npMapping, epMapping);
    }

    @Override
    public void doCopy() {
        ArrayList outNodes = new ArrayList(((Graph)this.inGraph).size());
        for (Object t : (Graph)this.inGraph) {
            Object n2 = this.copyNode(t);
            outNodes.add(new NodeRec(t, n2));
        }
        for (NodeRec nodeRec : outNodes) {
            Object n1 = nodeRec.inNode;
            Object n2 = nodeRec.outNode;
            for (Object edge : ((Graph)this.inGraph).getOutgoingEdges(n1)) {
                Object tgt1 = ((Graph)this.inGraph).getTarget(edge);
                this.copyEdge(n2, edge, tgt1);
            }
        }
    }

    private static class NodeRec<N1, N2> {
        private final N1 inNode;
        private final N2 outNode;

        NodeRec(N1 inNode, N2 outNode) {
            this.inNode = inNode;
            this.outNode = outNode;
        }
    }
}

