/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graph.traversal;

import net.automatalib.util.graph.traversal.SimpleDFRecord;
import org.checkerframework.checker.nullness.qual.Nullable;

final class DFRecord<N, E, D>
extends SimpleDFRecord<N, E> {
    final D data;
    private @Nullable LastEdge<E, N, D> lastEdge;

    DFRecord(N node, D data) {
        super(node);
        this.data = data;
    }

    @Nullable LastEdge<E, N, D> getLastEdge() {
        LastEdge<E, N, D> result = this.lastEdge;
        this.lastEdge = null;
        return result;
    }

    void setLastEdge(E edge, N tgtNode, D tgtData) {
        assert (this.lastEdge == null);
        this.lastEdge = new LastEdge<E, N, D>(edge, tgtNode, tgtData);
    }

    static final class LastEdge<E, N, D> {
        public final E edge;
        public final N node;
        public final D data;

        LastEdge(E edge, N node, D data) {
            this.edge = edge;
            this.node = node;
            this.data = data;
        }
    }
}

