/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.decomposition;

import org.ejml.data.DGrowArray;
import org.ejml.data.DMatrixRBlock;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.block.MatrixOps_DDRB;
import org.ejml.interfaces.decomposition.DecompositionInterface;

public class BaseDecomposition_DDRB_to_DDRM
implements DecompositionInterface<DMatrixRMaj> {
    protected DecompositionInterface<DMatrixRBlock> alg;
    protected DGrowArray workspace = new DGrowArray();
    protected DMatrixRBlock Ablock = new DMatrixRBlock();
    protected int blockLength;

    public BaseDecomposition_DDRB_to_DDRM(DecompositionInterface<DMatrixRBlock> alg, int blockLength) {
        this.alg = alg;
        this.blockLength = blockLength;
    }

    @Override
    public boolean decompose(DMatrixRMaj A2) {
        this.Ablock.numRows = A2.numRows;
        this.Ablock.numCols = A2.numCols;
        this.Ablock.blockLength = this.blockLength;
        this.Ablock.data = A2.data;
        MatrixOps_DDRB.convertRowToBlock(A2.numRows, A2.numCols, this.Ablock.blockLength, A2.data, this.workspace);
        boolean ret = this.alg.decompose(this.Ablock);
        if (!this.alg.inputModified()) {
            MatrixOps_DDRB.convertBlockToRow(A2.numRows, A2.numCols, this.Ablock.blockLength, A2.data, this.workspace);
        }
        return ret;
    }

    public void convertBlockToRow(int numRows, int numCols, double[] data) {
        MatrixOps_DDRB.convertBlockToRow(numRows, numCols, this.Ablock.blockLength, data, this.workspace);
    }

    @Override
    public boolean inputModified() {
        return this.alg.inputModified();
    }
}

