/*
 * Decompiled with CFR 0.152.
 */
package com.github.misberner.graphvizawtshapes;

import com.github.misberner.graphvizawtshapes.ShapeFactory;
import java.awt.Shape;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public class ShapeLibrary {
    private final Map<String, ShapeFactory> factories;

    private ShapeLibrary(Map<String, ShapeFactory> factories) {
        this.factories = factories;
    }

    public static ShapeLibrary getInstance() {
        return Holder.INSTANCE;
    }

    public Shape createShape(String shapeName) {
        ShapeFactory factory = this.getShapeFactory(shapeName);
        if (factory == null) {
            return null;
        }
        return factory.createShape();
    }

    public Shape createShape(String shapeName, int width, int height) {
        ShapeFactory factory = this.getShapeFactory(shapeName);
        if (factory == null) {
            return null;
        }
        return factory.createShape(width, height);
    }

    private ShapeFactory getShapeFactory(String shapeName) {
        shapeName = shapeName.toLowerCase();
        return this.factories.get(shapeName);
    }

    private static final class Holder {
        private static final ShapeLibrary INSTANCE;

        private Holder() {
        }

        static {
            ServiceLoader<ShapeFactory> shapeFactories = ServiceLoader.load(ShapeFactory.class);
            HashMap<String, ShapeFactory> factories = new HashMap<String, ShapeFactory>();
            for (ShapeFactory factory : shapeFactories) {
                String[] names;
                for (String name : names = factory.getShapeNames()) {
                    if (factories.containsKey(name = name.toLowerCase())) continue;
                    factories.put(name, factory);
                }
            }
            INSTANCE = new ShapeLibrary(factories);
        }
    }
}

