/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.acex;

import de.learnlib.acex.AbstractBaseCounterexample;
import de.learnlib.oracle.MembershipOracle;
import java.util.Objects;
import java.util.function.Function;
import net.automatalib.word.Word;

public class OutInconsPrefixTransformAcex<I, D>
extends AbstractBaseCounterexample<D> {
    private final Word<I> suffix;
    private final MembershipOracle<I, D> oracle;
    private final Function<Word<I>, Word<I>> asTransform;

    public OutInconsPrefixTransformAcex(Word<I> suffix, MembershipOracle<I, D> oracle, Function<Word<I>, Word<I>> asTransform) {
        this(suffix, suffix.length() + 1, oracle, asTransform);
    }

    protected OutInconsPrefixTransformAcex(Word<I> suffix, int length, MembershipOracle<I, D> oracle, Function<Word<I>, Word<I>> asTransform) {
        super(length);
        this.suffix = suffix;
        this.oracle = oracle;
        this.asTransform = asTransform;
    }

    @Override
    protected D computeEffect(int index) {
        Word<I> prefix = this.suffix.prefix(index);
        Word<I> suffix = this.suffix.subWord(index);
        Word<I> asPrefix = this.asTransform.apply(prefix);
        return this.oracle.answerQuery(asPrefix, suffix);
    }

    @Override
    public boolean checkEffects(D eff1, D eff2) {
        return Objects.equals(eff1, eff2);
    }
}

