/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.aaar.generic;

import de.learnlib.algorithm.LearnerConstructor;
import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.aaar.AbstractAAARLearner;
import de.learnlib.algorithm.aaar.abstraction.AbstractAbstractionTree;
import de.learnlib.algorithm.aaar.abstraction.GenericAbstractionTree;
import de.learnlib.oracle.MembershipOracle;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.alphabet.SupportsGrowingAlphabet;

public abstract class AbstractGenericAAARLearner<L extends LearningAlgorithm<CM, CI, D> & SupportsGrowingAlphabet<CI>, AM, CM, AI, CI, D>
extends AbstractAAARLearner<L, AM, CM, AI, CI, D> {
    private final AI initialAbstract;
    private final CI initialConcrete;
    private final GenericAbstractionTree<AI, CI, D> tree;

    public AbstractGenericAAARLearner(LearnerConstructor<L, CI, D> learnerConstructor, MembershipOracle<CI, D> oracle, CI initialConcrete, Function<CI, AI> abstractor) {
        super(learnerConstructor, oracle);
        this.initialConcrete = initialConcrete;
        this.initialAbstract = abstractor.apply(initialConcrete);
        this.tree = new GenericAbstractionTree<AI, CI, D>(this.initialAbstract, initialConcrete, oracle, abstractor);
    }

    @Override
    public Alphabet<CI> getLearnerAlphabet() {
        return Alphabets.fromCollection(this.tree.getRepresentativeSymbols());
    }

    @Override
    protected AbstractAbstractionTree<AI, CI, D> getTreeForRepresentative(CI ci) {
        return this.tree;
    }

    @Override
    protected Collection<AI> getInitialAbstracts() {
        return Collections.singleton(this.initialAbstract);
    }

    @Override
    protected Collection<CI> getInitialRepresentatives() {
        return Collections.singleton(this.initialConcrete);
    }

    public GenericAbstractionTree<AI, CI, D> getAbstractionTree() {
        return this.tree;
    }
}

